/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.util.AnnoUtil;
import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.annotation.ScriptBean;
import com.yomahub.liteflow.script.annotation.ScriptMethod;
import com.yomahub.liteflow.script.proxy.ScriptBeanProxy;
import com.yomahub.liteflow.script.proxy.ScriptMethodProxy;
import com.yomahub.liteflow.util.LOGOPrinter;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ComponentScanner
implements BeanPostProcessor {
    private static final String REFRESH_SCOPE_ANN_BEAN_PREFIX = "scopedTarget.";
    private static final String REFRESH_SCOPE_ANN_CLASS_PATH = "org.springframework.cloud.context.config.annotation.RefreshScope";
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanner.class);
    public static Map<String, NodeComponent> nodeComponentMap = new HashMap<String, NodeComponent>();
    private LiteflowConfig liteflowConfig;
    public static ICmpAroundAspect cmpAroundAspect;

    public ComponentScanner() {
        LOGOPrinter.print();
    }

    public ComponentScanner(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        if (liteflowConfig.getPrintBanner().booleanValue()) {
            LOGOPrinter.print();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = LiteFlowProxyUtil.getUserClass(bean.getClass());
        if (LiteFlowProxyUtil.isDeclareCmp(bean.getClass())) {
            LOG.info("proxy component[{}] has been found", (Object)beanName);
            List nodeComponents = LiteFlowProxyUtil.proxy2NodeComponent((Object)bean, (String)beanName);
            nodeComponents.forEach(nodeComponent -> {
                String nodeId = nodeComponent.getNodeId();
                nodeId = StrUtil.isEmpty((CharSequence)nodeId) ? this.getRealBeanName(clazz, beanName) : nodeId;
                nodeComponentMap.put(nodeId, (NodeComponent)nodeComponent);
            });
            if (nodeComponents.size() == 1) {
                return nodeComponents.get(0);
            }
            return bean;
        }
        if (NodeComponent.class.isAssignableFrom(clazz)) {
            LOG.info("component[{}] has been found", (Object)beanName);
            NodeComponent nodeComponent2 = (NodeComponent)bean;
            nodeComponentMap.put(this.getRealBeanName(clazz, beanName), nodeComponent2);
            return nodeComponent2;
        }
        if (ICmpAroundAspect.class.isAssignableFrom(clazz)) {
            LOG.info("component aspect implement[{}] has been found", (Object)beanName);
            cmpAroundAspect = (ICmpAroundAspect)bean;
            return cmpAroundAspect;
        }
        ScriptBean scriptBean = (ScriptBean)AnnoUtil.getAnnotation((AnnotatedElement)clazz, ScriptBean.class);
        if (ObjectUtil.isNotNull((Object)scriptBean)) {
            ScriptBeanProxy proxy = new ScriptBeanProxy(bean, clazz, scriptBean);
            ScriptBeanManager.addScriptBean((String)scriptBean.value(), (Object)proxy.getProxyScriptBean());
            return bean;
        }
        List scriptMethods = Arrays.stream(clazz.getMethods()).filter(method -> {
            ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
            return ObjectUtil.isNotNull((Object)scriptMethod) && StrUtil.isNotEmpty((CharSequence)scriptMethod.value());
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(scriptMethods)) {
            Map scriptMethodsGroupByValue = CollStreamUtil.groupBy(scriptMethods, method -> {
                ScriptMethod scriptMethod = (ScriptMethod)AnnoUtil.getAnnotation((AnnotatedElement)method, ScriptMethod.class);
                return scriptMethod.value();
            }, Collectors.toList());
            for (Map.Entry entry : scriptMethodsGroupByValue.entrySet()) {
                String key = (String)entry.getKey();
                List methods = (List)entry.getValue();
                ScriptMethodProxy proxy = new ScriptMethodProxy(bean, clazz, methods);
                ScriptBeanManager.addScriptBean((String)key, (Object)proxy.getProxyScriptMethod());
            }
            return bean;
        }
        return bean;
    }

    public static void cleanCache() {
        nodeComponentMap.clear();
    }

    private String getRealBeanName(Class<?> clazz, String beanName) {
        if (beanName.startsWith(REFRESH_SCOPE_ANN_BEAN_PREFIX)) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = AnnotationUtil.getAnnotations(clazz, (boolean)true)) {
                String name = annotation.annotationType().getName();
                if (!REFRESH_SCOPE_ANN_CLASS_PATH.equals(name)) continue;
                return beanName.replace(REFRESH_SCOPE_ANN_BEAN_PREFIX, "");
            }
        }
        return beanName;
    }
}

