/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.spring;

import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.core.proxy.DeclWarpBean;
import com.yomahub.liteflow.spi.ContextAware;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringAware
implements ApplicationContextAware,
ContextAware {
    private static ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public <T> T getBean(String name) {
        Object t = applicationContext.getBean(name);
        return (T)t;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) {
        return applicationContext.getBeansOfType(type);
    }

    public <T> T getBean(Class<T> clazz) {
        Object t = applicationContext.getBean(clazz);
        return (T)t;
    }

    private <T> T getBean(String beanName, Class<T> clazz) {
        Object t = applicationContext.getBean(beanName, clazz);
        return (T)t;
    }

    public <T> T registerBean(String beanName, Class<T> c) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(c.getName());
        beanFactory.setAllowBeanDefinitionOverriding(true);
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return this.getBean(beanName);
    }

    public Object registerDeclWrapBean(String beanName, DeclWarpBean declWarpBean) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        beanFactory.setAllowBeanDefinitionOverriding(true);
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DeclWarpBean.class);
        beanDefinition.setScope("singleton");
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        mutablePropertyValues.add("nodeId", (Object)declWarpBean.getNodeId());
        mutablePropertyValues.add("nodeName", (Object)declWarpBean.getNodeName());
        mutablePropertyValues.add("nodeType", (Object)declWarpBean.getNodeType());
        mutablePropertyValues.add("rawClazz", (Object)declWarpBean.getRawClazz());
        mutablePropertyValues.add("methodWrapBeanList", (Object)declWarpBean.getMethodWrapBeanList());
        mutablePropertyValues.add("rawBean", declWarpBean.getRawBean());
        beanDefinition.setPropertyValues(mutablePropertyValues);
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return this.getBean(beanName);
    }

    public <T> T registerBean(Class<T> c) {
        return this.registerBean(c.getName(), c);
    }

    public <T> T registerBean(String beanName, Object bean) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getAutowireCapableBeanFactory();
        defaultListableBeanFactory.registerSingleton(beanName, bean);
        return (T)configurableApplicationContext.getBean(beanName);
    }

    public <T> T registerOrGet(String beanName, Class<T> clazz) {
        if (ObjectUtil.isNull((Object)applicationContext)) {
            return null;
        }
        try {
            return this.getBean(beanName, clazz);
        }
        catch (Exception e) {
            return this.registerBean(beanName, clazz);
        }
    }

    public boolean hasBean(String beanName) {
        return applicationContext.containsBean(beanName);
    }

    public int priority() {
        return 1;
    }
}

