/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.context;

import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.tlog.context.TLogContext;
import org.apache.commons.lang3.StringUtils;

public class SpanIdGenerator {
    private static TransmittableThreadLocal<String> currentSpanIdTL = new TransmittableThreadLocal();
    private static TransmittableThreadLocal<Integer> spanIndex = new TransmittableThreadLocal();
    private static String INITIAL_VALUE = "0";

    public static void putSpanId(String spanId) {
        if (StringUtils.isBlank((CharSequence)spanId)) {
            spanId = INITIAL_VALUE;
        }
        currentSpanIdTL.set((Object)spanId);
        spanIndex.set((Object)Integer.valueOf(INITIAL_VALUE));
    }

    public static String getSpanId() {
        return (String)currentSpanIdTL.get();
    }

    public static void removeSpanId() {
        currentSpanIdTL.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateNextSpanId() {
        String string = TLogContext.getTraceId();
        synchronized (string) {
            String currentSpanId = TLogContext.getSpanId();
            spanIndex.set((Object)((Integer)spanIndex.get() + 1));
            String nextSpanId = StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{currentSpanId, spanIndex.get()});
            return nextSpanId;
        }
    }
}

