/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.hutoolhttp;

import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpInterceptor;
import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogHutoolhttpInterceptor
implements HttpInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(HttpBase httpBase) {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            httpBase.header("tlogTraceId", traceId);
            httpBase.header("tlogSpanId", SpanIdGenerator.generateNextSpanId());
            httpBase.header("preIvkApp", appName);
            httpBase.header("preIvkHost", LocalhostUtil.getHostName());
            httpBase.header("preIp", LocalhostUtil.getHostIp());
        } else {
            this.log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

