/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.webflux.aop;

import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.core.rpc.TLogRPCHandler;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

@Aspect
@Order(value=10)
public class ShenyuPluginLogAop {
    private static final Integer FIRST = 0;
    private static TLogRPCHandler tLogRPCHandler = new TLogRPCHandler();

    @Before(value="execution(* org.apache.shenyu.plugin..*.execute(..))")
    public void startLog(JoinPoint joinPoint) {
        List preIps;
        List preIvkHosts;
        List preIvkApps;
        List spanIds;
        String traceId = null;
        String spanId = null;
        String preIvkApp = null;
        String preIvkHost = null;
        String preIp = null;
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length < 1) {
            return;
        }
        if (args[0] == null || !(args[0] instanceof ServerWebExchange)) {
            return;
        }
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        HttpHeaders headers = exchange.getRequest().getHeaders();
        List traceIds = headers.get((Object)"tlogTraceId");
        if (traceIds != null && traceIds.size() > 0) {
            traceId = (String)traceIds.get(FIRST);
        }
        if ((spanIds = headers.get((Object)"tlogSpanId")) != null && spanIds.size() > 0) {
            spanId = (String)spanIds.get(FIRST);
        }
        if ((preIvkApps = headers.get((Object)"preIvkApp")) != null && preIvkApps.size() > 0) {
            preIvkApp = (String)preIvkApps.get(FIRST);
        }
        if ((preIvkHosts = headers.get((Object)"preIvkHost")) != null && preIvkHosts.size() > 0) {
            preIvkHost = (String)preIvkHosts.get(FIRST);
        }
        if ((preIps = headers.get((Object)"preIp")) != null && preIps.size() > 0) {
            preIp = (String)preIps.get(FIRST);
        }
        TLogLabelBean labelBean = new TLogLabelBean(preIvkApp, preIvkHost, preIp, traceId, spanId);
        tLogRPCHandler.processProviderSide(labelBean);
    }
}

