/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.web.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.web.interceptor.AbsTLogWebHandlerMethodInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class TLogWebInvokeTimeInterceptor
extends AbsTLogWebHandlerMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TLogWebInvokeTimeInterceptor.class);
    private final TransmittableThreadLocal<StopWatch> invokeTimeTL = new TransmittableThreadLocal();

    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (TLogContext.enableInvokeTimePrint()) {
            String url = request.getRequestURI();
            String parameters = JSON.toJSONString((Object)request.getParameterMap());
            log.info("[TLOG]\u5f00\u59cb\u8bf7\u6c42URL[{}],\u53c2\u6570\u4e3a:{}", (Object)url, (Object)parameters);
            StopWatch stopWatch = new StopWatch();
            this.invokeTimeTL.set((Object)stopWatch);
            stopWatch.start();
        }
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (TLogContext.enableInvokeTimePrint()) {
            StopWatch stopWatch = (StopWatch)this.invokeTimeTL.get();
            stopWatch.stop();
            log.info("[TLOG]\u7ed3\u675fURL[{}]\u7684\u8c03\u7528,\u8017\u65f6\u4e3a:{}\u6beb\u79d2", (Object)request.getRequestURI(), (Object)stopWatch.getTime());
            this.invokeTimeTL.remove();
        }
    }

    private boolean isJson(HttpServletRequest request) {
        if (request.getContentType() != null) {
            return request.getContentType().equals("application/json") || request.getContentType().equals("application/json;charset=UTF-8");
        }
        return false;
    }
}

