/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yoti.mobile.android.commons.ui.widgets.R;

public class HorizontalScrollingGradient
extends View {
    private final boolean a;
    private Path b;
    private Drawable c;
    private Rect d;
    private int e;
    private int f;
    private int g;
    private int h;
    private ValueAnimator i;
    private boolean j;
    private int k;
    private boolean l;

    public HorizontalScrollingGradient(Context context) {
        this(context, null);
    }

    public HorizontalScrollingGradient(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        Drawable drawable;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.HorizontalScrollingGradient, 0, 0);
        this.a = typedArray.getBoolean(R.styleable.HorizontalScrollingGradient_isCircle, false);
        if (this.a) {
            this.b = new Path();
        }
        if ((drawable = typedArray.getDrawable(R.styleable.HorizontalScrollingGradient_drawable)) == null) {
            throw new IllegalArgumentException("HorizontalScrollingGradient.drawable must be set");
        }
        this.c = drawable;
        this.h = typedArray.getDimensionPixelSize(R.styleable.HorizontalScrollingGradient_drawableWidthDp, this.c.getIntrinsicWidth());
        this.k = typedArray.getInt(R.styleable.HorizontalScrollingGradient_durationMs, 1000);
        typedArray.recycle();
        this.d = new Rect();
        this.e = -this.h;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.g = this.getMeasuredWidth();
        this.f = this.getMeasuredHeight();
        if (this.a) {
            float f2 = this.g / 2;
            float f3 = this.f / 2;
            float f4 = Math.max(f2, f3);
            this.b.addCircle(f2, f3, f4, Path.Direction.CCW);
        }
        if (0 == this.getVisibility()) {
            this.startAnimation();
        }
    }

    protected void onVisibilityChanged(@NonNull View view, int n) {
        super.onVisibilityChanged(view, n);
        if (0 != n) {
            this.b();
        } else {
            this.startAnimation();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.j) {
            this.d.left = this.e;
            this.d.top = 0;
            this.d.right = this.e + this.h;
            this.d.bottom = this.f;
            this.c.setBounds(this.d);
            if (this.b != null) {
                canvas.clipPath(this.b);
            }
            this.c.draw(canvas);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.b();
    }

    public void startAnimation() {
        if (!this.j && !this.l && this.g != 0 && this.f != 0) {
            this.j = true;
            this.a();
            this.i.removeAllListeners();
            this.i.removeAllUpdateListeners();
            this.i.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    HorizontalScrollingGradient.this.e = ((Float)valueAnimator.getAnimatedValue()).intValue();
                    HorizontalScrollingGradient.this.invalidate();
                }
            });
            this.i.start();
            this.invalidate();
        }
    }

    private void a() {
        if (this.i == null) {
            this.i = ValueAnimator.ofFloat((float[])new float[]{-this.h, this.g});
            this.i.setRepeatCount(-1);
            this.i.setDuration((long)this.k);
        }
    }

    private void b() {
        this.j = false;
        if (this.i != null) {
            this.i.removeAllListeners();
            this.i.removeAllUpdateListeners();
            this.i.end();
            this.invalidate();
        }
    }

    public void dismiss() {
        this.l = true;
        this.b();
    }
}

