/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.swiperefreshlayout.widget.CircularProgressDrawable;
import com.google.android.material.button.MaterialButton;
import com.yoti.mobile.android.commons.ui.widgets.R;

public class YotiButton
extends MaterialButton {
    private Drawable a;

    public YotiButton(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YotiButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        boolean bl;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.YotiButton, 0, 0);
        try {
            bl = typedArray.getBoolean(R.styleable.YotiButton_textUnderline, false);
        }
        finally {
            typedArray.recycle();
        }
        this.setTextUnderline(bl);
        this.a = this.getIcon();
    }

    public void setTextUnderline(boolean bl) {
        this.setPaintFlags(bl ? this.getPaintFlags() | 8 : this.getPaintFlags() & 0xFFFFFFF7);
    }

    public void setDrawableTint(@ColorInt @Nullable int n) {
        Drawable[] drawableArray;
        for (Drawable drawable : drawableArray = this.getCompoundDrawables()) {
            if (drawable == null) continue;
            drawable.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void showProgress() {
        this.a((Drawable)this.a());
    }

    private CircularProgressDrawable a() {
        CircularProgressDrawable circularProgressDrawable = new CircularProgressDrawable(this.getContext());
        circularProgressDrawable.setStyle(0);
        int n = (int)(circularProgressDrawable.getCenterRadius() + circularProgressDrawable.getStrokeWidth()) * 2;
        circularProgressDrawable.setColorSchemeColors(new int[]{this.getTextColors().getDefaultColor()});
        circularProgressDrawable.setBounds(0, 0, n, n);
        return circularProgressDrawable;
    }

    private void b() {
        int n = this.getContext().getResources().getDimensionPixelSize(R.dimen.loading_padding_end);
        this.setPadding(this.getPaddingStart() + n, this.getPaddingTop(), this.getPaddingEnd(), this.getPaddingBottom());
    }

    private void c() {
        int n = this.getContext().getResources().getDimensionPixelSize(R.dimen.loading_padding_end);
        this.setPadding(this.getPaddingStart() - n, this.getPaddingTop(), this.getPaddingEnd(), this.getPaddingBottom());
    }

    private void a(Drawable drawable) {
        drawable.setCallback(new Drawable.Callback(){

            public void invalidateDrawable(@NonNull Drawable drawable) {
            }

            public void scheduleDrawable(@NonNull Drawable drawable, @NonNull Runnable runnable, long l) {
                YotiButton.this.invalidate();
            }

            public void unscheduleDrawable(@NonNull Drawable drawable, @NonNull Runnable runnable) {
            }
        });
        if (drawable instanceof Animatable) {
            ((Animatable)drawable).start();
        }
        this.setIcon(drawable);
        this.setIconGravity(3);
        if (this.a == null) {
            this.b();
        }
    }

    public void hideProgress() {
        Drawable drawable = this.getIcon();
        if (drawable instanceof Animatable) {
            ((Animatable)drawable).stop();
            drawable.setCallback(null);
        }
        this.setIcon(this.a);
        this.setIconGravity(3);
        if (this.a == null) {
            this.c();
        }
    }
}

