/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.widget.TextViewCompat;
import com.airbnb.lottie.LottieAnimationView;
import com.yoti.mobile.android.common.ui.widgets.YotiRadioGroup;
import com.yoti.mobile.android.commons.ui.widgets.R;

public class YotiRadioButton
extends RelativeLayout
implements Checkable {
    private static final int[] a = new int[]{0x10100A0};
    @NonNull
    private ViewGroup b;
    @NonNull
    private RadioButton c;
    @NonNull
    private TextView d;
    @NonNull
    private LottieAnimationView e;
    @Nullable
    private OnCheckedChangeListener f;
    private int g = 0;
    private int h = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YotiRadioButton(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.YotiRadioButton, 0, 0);
        try {
            CharSequence charSequence = typedArray.getText(R.styleable.YotiRadioButton_android_text);
            CharSequence charSequence2 = typedArray.getText(R.styleable.YotiRadioButton_radioAdditionalText);
            int n = typedArray.getResourceId(R.styleable.YotiRadioButton_radioTextAppearance, R.style.Yoti_v3_Font_DisplayRegular);
            int n2 = typedArray.getResourceId(R.styleable.YotiRadioButton_radioAdditionalTextAppearance, R.style.Yoti_v3_Font_DisplayRegular);
            boolean bl = typedArray.getBoolean(R.styleable.YotiRadioButton_radioMultiLine, false);
            YotiRadioButton.inflate((Context)context, (int)(bl ? R.layout.yoti_radiobutton_multiline : R.layout.yoti_radiobutton), (ViewGroup)this);
            this.b = (ViewGroup)this.findViewById(R.id.rootView);
            this.c = (RadioButton)this.findViewById(R.id.radio_button);
            this.d = (TextView)this.findViewById(R.id.tv_additional);
            this.e = (LottieAnimationView)this.findViewById(R.id.radiobutton_indicator);
            this.c.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (YotiRadioButton.this.getParent() instanceof YotiRadioGroup) {
                        ((YotiRadioGroup)YotiRadioButton.this.getParent()).onChildCheckedChanged(YotiRadioButton.this, bl);
                    }
                    if (YotiRadioButton.this.f != null) {
                        YotiRadioButton.this.f.onCheckedChanged(YotiRadioButton.this, bl);
                    }
                    YotiRadioButton.this.e.setAnimation(bl ? "lottie/radiobutton_indicator_selected.json" : "lottie/radiobutton_indicator_unselected.json");
                    YotiRadioButton.this.e.addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            YotiRadioButton.this.e.removeAnimatorListener((Animator.AnimatorListener)this);
                        }

                        public void onAnimationCancel(Animator animator) {
                            YotiRadioButton.this.e.removeAnimatorListener((Animator.AnimatorListener)this);
                        }
                    });
                    YotiRadioButton.this.e.playAnimation();
                    YotiRadioButton.this.a(bl);
                    if (bl) {
                        YotiRadioButton.this.b.sendAccessibilityEvent(8);
                    }
                }
            });
            this.c.setText(charSequence);
            this.setAdditionalText(charSequence2);
            TextViewCompat.setTextAppearance((TextView)this.c, (int)n);
            TextViewCompat.setTextAppearance((TextView)this.d, (int)n2);
            this.a(this.c.isChecked());
            if (typedArray.getBoolean(R.styleable.YotiRadioButton_radioMultiLineWithSpaceAdjustment, false)) {
                this.a(typedArray, context);
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    private void a(TypedArray typedArray, Context context) {
        this.c.setMinimumHeight(0);
        float f2 = typedArray.getDimension(R.styleable.YotiRadioButton_radioTextStartMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_text_start_margin_default));
        float f3 = typedArray.getDimension(R.styleable.YotiRadioButton_radioTextTopMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_text_top_margin_default));
        float f4 = typedArray.getDimension(R.styleable.YotiRadioButton_radioAdditionalTextTopMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_additional_text_top_margin_default));
        float f5 = typedArray.getDimension(R.styleable.YotiRadioButton_radioAdditionalTextBottomMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_additional_text_bottom_margin_default));
        float f6 = typedArray.getDimension(R.styleable.YotiRadioButton_radioIconStartMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_icon_start_margin_default));
        float f7 = typedArray.getDimension(R.styleable.YotiRadioButton_radioIconEndMargin, (float)context.getResources().getDimensionPixelSize(R.dimen.radiobutton_icon_end_margin_default));
        this.a((View)this.c, f2, f3, 0.0f, 0.0f);
        this.a((View)this.d, 0.0f, f4, 0.0f, f5);
        this.a((View)this.e, f6, 0.0f, f7, 0.0f);
    }

    private void a(View view, float f2, float f3, float f4, float f5) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins((int)f2, (int)f3, (int)f4, (int)f5);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return motionEvent.getActionMasked() == 0;
    }

    protected void onDetachedFromWindow() {
        if (this.e.getProgress() > 0.0f && this.e.getProgress() < 1.0f) {
            this.e.setProgress(1.0f);
        }
        super.onDetachedFromWindow();
    }

    public int[] onCreateDrawableState(int n) {
        if (this.getRadioButton() != null && this.isChecked()) {
            int[] nArray = super.onCreateDrawableState(n + 1);
            View.mergeDrawableStates((int[])nArray, (int[])a);
            return nArray;
        }
        return super.onCreateDrawableState(n);
    }

    public boolean performClick() {
        super.performClick();
        return this.c.performClick();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.e.setAlpha(bl ? 1.0f : 0.5f);
    }

    public void setChecked(boolean bl) {
        this.getRadioButton().setChecked(bl);
        this.refreshDrawableState();
    }

    public boolean isChecked() {
        return this.getRadioButton().isChecked();
    }

    public void toggle() {
        this.getRadioButton().toggle();
    }

    public RadioButton getRadioButton() {
        return this.c;
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener onCheckedChangeListener) {
        this.f = onCheckedChangeListener;
    }

    public void setText(@StringRes int n) {
        this.getRadioButton().setText(n);
    }

    public void setText(CharSequence charSequence) {
        this.getRadioButton().setText(charSequence);
    }

    public void setTextAppearance(@StyleRes int n) {
        TextViewCompat.setTextAppearance((TextView)this.c, (int)n);
    }

    public void setAdditionalText(CharSequence charSequence) {
        this.d.setText(charSequence);
        this.d.setVisibility(TextUtils.isEmpty((CharSequence)charSequence) ? 8 : 0);
    }

    public void setAdditionalTextAppearance(@StyleRes int n) {
        TextViewCompat.setTextAppearance((TextView)this.d, (int)n);
    }

    public String getText() {
        return this.getRadioButton().getText().toString();
    }

    public void bindForAccessibility(int n, int n2) {
        this.g = n;
        this.h = n2;
        this.a(this.isChecked());
    }

    private void a(boolean bl) {
        String string2 = this.c.getText().toString();
        if (this.d.getVisibility() != 8 && this.d.getText().length() > 0) {
            string2 = string2 + ", " + this.d.getText().toString();
        }
        String string3 = bl ? this.getResources().getString(R.string.loc_radio_button_selected_accessibility, new Object[]{string2, this.g, this.h}) : this.getResources().getString(R.string.loc_radio_button_default_accessibility, new Object[]{string2, this.g, this.h});
        this.b.setContentDescription((CharSequence)string3);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(YotiRadioButton var1, boolean var2);
    }
}

