/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets.date.entry;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yoti.mobile.android.common.ui.widgets.date.entry.DatesArrayBuilder;
import com.yoti.mobile.android.common.ui.widgets.date.entry.HintSpinnerAdapter;
import com.yoti.mobile.android.commons.ui.widgets.R;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class YotiDateEntryView
extends RelativeLayout
implements AdapterView.OnItemSelectedListener {
    private OnManualDateEntryInteraction i;
    private LayoutInflater j;
    private HintSpinnerAdapter k;
    private HintSpinnerAdapter l;
    private HintSpinnerAdapter m;
    private DatesArrayBuilder n;
    private String o;
    private TextView p;
    private TextView q;
    protected Spinner a;
    protected Spinner b;
    protected Spinner c;
    protected String d;
    protected String e;
    protected String f;
    int g;
    int h;

    public YotiDateEntryView(@NonNull Context context, @NonNull String string2) {
        super(context);
        this.j = LayoutInflater.from((Context)context);
        this.o = string2;
        this.init(context, null);
    }

    public YotiDateEntryView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.j = LayoutInflater.from((Context)context);
        this.init(context, attributeSet);
    }

    public YotiDateEntryView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.j = LayoutInflater.from((Context)context);
        this.init(context, attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context, AttributeSet attributeSet) {
        this.j.inflate(R.layout.view_date_entry, (ViewGroup)this, true);
        this.g = -1;
        this.h = -1;
        if (attributeSet != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.YotiDateEntryView, 0, 0);
            try {
                this.g = typedArray.getInteger(R.styleable.YotiDateEntryView_maximumYearsAfterNow, -1);
                this.h = typedArray.getInteger(R.styleable.YotiDateEntryView_maximumYearsBeforeNow, -1);
                this.d = typedArray.getString(R.styleable.YotiDateEntryView_hintDay);
                this.e = typedArray.getString(R.styleable.YotiDateEntryView_hintMonth);
                this.f = typedArray.getString(R.styleable.YotiDateEntryView_hintYear);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.n = new DatesArrayBuilder(this.g);
        if (this.h > -1) {
            int n = Calendar.getInstance().get(1);
            this.n.setMinimumYear(n - this.h);
        }
        this.q = (TextView)this.findViewById(R.id.error_message);
        this.a();
        this.b();
        this.f();
    }

    private void a() {
        this.p = (TextView)this.findViewById(R.id.dob_label);
        this.p.setText((CharSequence)this.o);
    }

    private void b() {
        this.e();
        this.d();
        this.c();
    }

    private void c() {
        List<String> list = this.n.buildYearsArray();
        list.add(this.f);
        this.m = new HintSpinnerAdapter(this.getContext(), R.layout.spinner_simple_item, list);
    }

    private void d() {
        List<String> list = this.n.buildMonthsArray();
        list.add(this.e);
        this.l = new HintSpinnerAdapter(this.getContext(), R.layout.spinner_simple_item, list);
    }

    private void e() {
        List<String> list = this.n.buildDaysArray(0, 1900);
        list.add(this.d);
        this.k = new HintSpinnerAdapter(this.getContext(), R.layout.spinner_simple_item, list);
    }

    private void f() {
        this.a = (Spinner)this.findViewById(R.id.spinnerDay);
        this.a.setAdapter((SpinnerAdapter)this.k);
        this.a.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.a.setSelection(this.k.getCount());
        this.k.setDropDownViewResource(R.layout.spinner_date_item);
        this.b = (Spinner)this.findViewById(R.id.spinnerMonth);
        this.b.setAdapter((SpinnerAdapter)this.l);
        this.b.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.b.setSelection(this.l.getCount());
        this.l.setDropDownViewResource(R.layout.spinner_date_item);
        this.c = (Spinner)this.findViewById(R.id.spinnerYear);
        this.c.setAdapter((SpinnerAdapter)this.m);
        this.c.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.c.setSelection(this.m.getCount());
        this.m.setDropDownViewResource(R.layout.spinner_date_item);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.p.setEnabled(bl);
        this.q.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
    }

    public void setTitle(String string2) {
        if (this.p != null) {
            this.p.setText((CharSequence)string2);
        }
    }

    public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
        if (this.i != null) {
            this.i.onDateEntry(adapterView.getId());
        }
        if (this.a(adapterView, n)) {
            int n2 = 0;
            int n3 = 0;
            if (adapterView.getId() == R.id.spinnerMonth) {
                n3 = n;
                n2 = Integer.valueOf((String)this.c.getSelectedItem());
            } else if (adapterView.getId() == R.id.spinnerYear) {
                n2 = Integer.valueOf((String)this.m.getItem(n));
                n3 = this.b.getSelectedItemPosition();
            }
            if (n2 != 0 && n3 != 0) {
                this.a(n3, n2);
            }
        }
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    private void a(int n, int n2) {
        List<String> list = this.n.buildDaysArray(n, n2);
        if (!list.isEmpty()) {
            list.add(this.d);
            this.k.clear();
            this.k.addAll(list);
        }
    }

    private boolean a(AdapterView<?> adapterView, int n) {
        if (adapterView.getId() == R.id.spinnerMonth) {
            return n < this.b.getCount() && !((String)this.c.getSelectedItem()).equalsIgnoreCase(this.f);
        }
        if (adapterView.getId() == R.id.spinnerYear) {
            return n < this.c.getCount() && !((String)this.b.getSelectedItem()).equalsIgnoreCase(this.e);
        }
        return false;
    }

    public boolean allDatesEntered() {
        return !((String)this.c.getSelectedItem()).equalsIgnoreCase(this.f) && !((String)this.b.getSelectedItem()).equalsIgnoreCase(this.e) && !((String)this.a.getSelectedItem()).equalsIgnoreCase(this.d);
    }

    public void setInteractionListener(OnManualDateEntryInteraction onManualDateEntryInteraction) {
        this.i = onManualDateEntryInteraction;
    }

    public Calendar getCurrentDateAsCalendar() {
        Calendar calendar = null;
        if (this.allDatesEntered()) {
            calendar = GregorianCalendar.getInstance();
            calendar.set(5, Integer.valueOf((String)this.a.getSelectedItem()));
            calendar.set(2, this.b.getSelectedItemPosition());
            calendar.set(1, Integer.valueOf((String)this.c.getSelectedItem()));
        }
        return calendar;
    }

    @Nullable
    public Long getCurrentDateAsMillis() {
        Calendar calendar = this.getCurrentDateAsCalendar();
        if (calendar == null) {
            return null;
        }
        return calendar.getTimeInMillis();
    }

    public void setDateFromCalendar(Calendar calendar) {
        this.a.setSelection(calendar.get(5) - 1);
        this.b.setSelection(calendar.get(2));
        this.c.setSelection(this.a(calendar.get(1)));
    }

    public void setDateFromMillis(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        calendar.setTimeInMillis(l);
        this.setDateFromCalendar(calendar);
    }

    public void setHardcodedYear(int n) {
        this.c.setSelection(this.a(n));
        this.c.setEnabled(false);
    }

    public void setErrorMessage(String string2) {
        this.q.setText((CharSequence)string2);
    }

    public void setErrorMessage(@IdRes int n, @StringRes int n2) {
        this.q.setId(n);
        this.q.setText(n2);
    }

    public void showErrorMessage(boolean bl) {
        this.q.setVisibility(bl ? 0 : 4);
    }

    private int a(int n) {
        int n2;
        if (this.h > -1) {
            int n3 = Calendar.getInstance().get(1);
            n2 = n - n3 - this.h;
        } else {
            n2 = n - 1900;
        }
        return n2;
    }

    public static interface OnManualDateEntryInteraction {
        public void onDateEntry(int var1);
    }
}

