/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets.date.picker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yoti.mobile.android.common.ui.widgets.YotiEditText;
import com.yoti.mobile.android.common.ui.widgets.date.picker.DatePicker;
import com.yoti.mobile.android.common.ui.widgets.date.picker.DatePickerDialog;
import com.yoti.mobile.android.common.ui.widgets.date.picker.SpinnerDatePickerDialogBuilder;
import com.yoti.mobile.android.commons.ui.widgets.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DatePickerComponent
extends ConstraintLayout {
    private DateParts a;
    private DateParts b;
    private DateParts c;
    private DateParts d;
    private DatePickerListener e;
    private String f;
    private ViewGroup g;
    private SimpleDateFormat h;
    private String i;
    private YotiEditText j;
    @StyleRes
    private int k;

    public DatePickerComponent(Context context) {
        this(context, null);
    }

    public DatePickerComponent(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatePickerComponent(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Drawable drawable2;
        String string2;
        String string3;
        String string4;
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.DatePickerComponent);
        try {
            String string5 = typedArray.getString(R.styleable.DatePickerComponent_date_picker_selected_date_format);
            this.h = string5 == null ? new SimpleDateFormat("dd MMMM yyyy", Locale.UK) : new SimpleDateFormat(string5, Locale.UK);
            this.i = typedArray.getString(R.styleable.DatePickerComponent_date_picker_dialog_date_pattern);
            if (this.i == null) {
                this.i = "dd MMM yyyy";
            }
            this.k = typedArray.getResourceId(R.styleable.DatePickerComponent_date_picker_spinner_theme, R.style.Yoti_v3_DatePickerSpinner);
            string4 = typedArray.getString(R.styleable.DatePickerComponent_date_picker_label);
            string3 = typedArray.getString(R.styleable.DatePickerComponent_date_picker_error);
            string2 = typedArray.getString(R.styleable.DatePickerComponent_date_picker_hint);
            drawable2 = typedArray.getDrawable(R.styleable.DatePickerComponent_date_picker_icon);
        }
        finally {
            typedArray.recycle();
        }
        this.a(context, string4, string3, string2, drawable2);
    }

    private void a(@NonNull Context context, String string2, String string3, String string4, Drawable drawable2) {
        LayoutInflater.from((Context)context).inflate(R.layout.date_picker_component, (ViewGroup)this, true);
        this.a();
        this.a(string2, string3, string4, drawable2);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerComponent.this.b();
            }
        });
        this.j.setCursorVisible(false);
        this.j.setInputType(524288);
    }

    private void a() {
        this.j = (YotiEditText)this.findViewById(R.id.date_picker_input_field);
    }

    private void a(String string2, String string3, String string4, Drawable drawable2) {
        this.j.setLabelText(string2);
        this.j.setErrorText(string3);
        this.j.setHintText(string4);
        this.j.setRightIcon(drawable2);
    }

    public void setDatePickerListener(@NonNull DatePickerListener datePickerListener) {
        this.e = datePickerListener;
    }

    public void setDefaultDate(DateParts dateParts) {
        this.b = DateParts.from(dateParts);
    }

    public void setDefaultDate(Calendar calendar) {
        this.b = DateParts.from(calendar);
    }

    public void setMinDate(DateParts dateParts) {
        this.c = DateParts.from(dateParts);
    }

    public void setMinDate(Calendar calendar) {
        this.c = DateParts.from(calendar);
    }

    public void setMaxDate(DateParts dateParts) {
        this.d = DateParts.from(dateParts);
    }

    public void setMaxDate(Calendar calendar) {
        this.d = DateParts.from(calendar);
    }

    public void setParent(ViewGroup viewGroup) {
        this.g = viewGroup;
    }

    public void setTitle(String string2) {
        this.f = string2;
    }

    public void setSpinnerTheme(@StyleRes int n) {
        this.k = n;
    }

    public void setDialogPickerDatePattern(@Nullable String string2) {
        this.i = string2;
    }

    public void clear() {
        this.a = null;
        this.j.setText("");
    }

    public void setAsValid() {
        this.j.setAsValid();
    }

    public void setAsInvalid() {
        this.j.setAsInvalid();
    }

    public void setAsEmptyInvalid() {
        this.j.setAsEmptyInvalid();
    }

    public void setAsNeutral() {
        this.j.setAsNeutral();
    }

    public void setAsInFocus() {
        this.j.setAsInFocus();
    }

    public String getText() {
        return this.j.getText();
    }

    public String getLabelText() {
        return this.j.getLabelText();
    }

    public void setDate(DateParts dateParts) {
        this.a = DateParts.from(dateParts);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.a.getYear(), this.a.getMonth(), this.a.getDayOfMonth());
        this.j.setText(this.h.format(gregorianCalendar.getTime()));
    }

    private void b() {
        SpinnerDatePickerDialogBuilder spinnerDatePickerDialogBuilder = new SpinnerDatePickerDialogBuilder().setParent(this.g).setDateSetListener(new DatePickerDialog.OnDateSetListener(){

            @Override
            public void onDateSet(DatePicker datePicker, int n, int n2, int n3) {
                DatePickerComponent.this.a = new DateParts(n, n2, n3);
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
                DatePickerComponent.this.j.setText(DatePickerComponent.this.h.format(gregorianCalendar.getTime()));
                if (DatePickerComponent.this.e != null) {
                    DatePickerComponent.this.e.onDateSelected(DatePickerComponent.this.a);
                }
            }
        });
        spinnerDatePickerDialogBuilder.setDatePattern(this.i);
        if (this.k != -1) {
            spinnerDatePickerDialogBuilder.spinnerTheme(this.k);
        }
        if (this.c != null) {
            spinnerDatePickerDialogBuilder.minDate(this.c.getYear(), this.c.getMonth(), this.c.getDayOfMonth());
        }
        if (this.d != null) {
            spinnerDatePickerDialogBuilder.maxDate(this.d.getYear(), this.d.getMonth(), this.d.getDayOfMonth());
        }
        if (this.a != null) {
            spinnerDatePickerDialogBuilder.defaultDate(this.a.getYear(), this.a.getMonth(), this.a.getDayOfMonth());
        } else if (this.b != null) {
            spinnerDatePickerDialogBuilder.defaultDate(this.b.getYear(), this.b.getMonth(), this.b.getDayOfMonth());
        }
        if (this.f != null) {
            spinnerDatePickerDialogBuilder.setTitle(this.f);
        }
        spinnerDatePickerDialogBuilder.build().show();
    }

    public static class DateParts
    implements Parcelable {
        private int a;
        private int b;
        private int c;
        public static final Parcelable.Creator<DateParts> CREATOR = new Parcelable.Creator<DateParts>(){

            public DateParts a(Parcel parcel) {
                return new DateParts(parcel);
            }

            public DateParts[] a(int n) {
                return new DateParts[n];
            }

            public /* synthetic */ Object[] newArray(int n) {
                return this.a(n);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };

        public DateParts(int n, int n2, int n3) {
            this.a = n;
            this.b = n2;
            this.c = n3;
        }

        protected DateParts(Parcel parcel) {
            this.a = parcel.readInt();
            this.b = parcel.readInt();
            this.c = parcel.readInt();
        }

        public int getYear() {
            return this.a;
        }

        public void setYear(int n) {
            this.a = n;
        }

        public int getMonth() {
            return this.b;
        }

        public void setMonth(int n) {
            this.b = n;
        }

        public int getDayOfMonth() {
            return this.c;
        }

        public void setDayOfMonth(int n) {
            this.c = n;
        }

        @NonNull
        public static DateParts from(DateParts dateParts) {
            return new DateParts(dateParts.getYear(), dateParts.getMonth(), dateParts.getDayOfMonth());
        }

        @NonNull
        public static DateParts from(Calendar calendar) {
            return new DateParts(calendar.get(1), calendar.get(2), calendar.get(5));
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.a);
            parcel.writeInt(this.b);
            parcel.writeInt(this.c);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DateParts dateParts = (DateParts)object;
            return this.a == dateParts.getYear() && this.b == dateParts.getMonth() && this.c == dateParts.getDayOfMonth();
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = n * n2 + this.a;
            n2 = n * n2 + this.b;
            n2 = n * n2 + this.c;
            return n2;
        }
    }

    public static interface DatePickerListener {
        public void onDateSelected(DateParts var1);
    }
}

