/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.common.ui.widgets.utils;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import android.view.animation.Animation;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.transition.Transition;
import com.airbnb.lottie.LottieAnimationView;

public class AnimationUtils {
    public static final float ANIMATION_PLAY_SPEED = 1.0f;
    public static final float ANIMATION_REVERSE_PLAY_SPEED = -1.0f;

    public static void animateAlpha(View view, float f2, float f3, long l) {
        AnimationUtils.animateAlpha(view, f2, f3, l, null);
    }

    public static void animateAlpha(View view, float f2, float f3, long l, Animator.AnimatorListener animatorListener) {
        if (view == null) {
            return;
        }
        if (view.getVisibility() != 0) {
            view.setVisibility(0);
        }
        if (view.getAlpha() != f2) {
            view.setAlpha(f2);
        }
        view.animate().alpha(f3).setDuration(l).setListener(animatorListener).start();
    }

    public static Runnable animateFromJson(LottieAnimationView lottieAnimationView, String string2) {
        return AnimationUtils.animateFromJson(lottieAnimationView, string2, 0L, false);
    }

    public static Runnable animateFromJson(LottieAnimationView lottieAnimationView, String string2, long l) {
        return AnimationUtils.animateFromJson(lottieAnimationView, string2, l, false);
    }

    public static Runnable animateFromJson(LottieAnimationView lottieAnimationView, String string2, boolean bl) {
        return AnimationUtils.animateFromJson(lottieAnimationView, string2, 0L, bl);
    }

    public static Runnable animateFromJson(final LottieAnimationView lottieAnimationView, String string2, long l, final boolean bl) {
        if (lottieAnimationView == null) {
            return null;
        }
        Context context = lottieAnimationView.getContext();
        if (context == null) {
            return null;
        }
        lottieAnimationView.setAnimation(string2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AnimationUtils.b(lottieAnimationView, bl);
            }
        };
        lottieAnimationView.postDelayed(runnable, l);
        return runnable;
    }

    private static void b(LottieAnimationView lottieAnimationView, boolean bl) {
        lottieAnimationView.cancelAnimation();
        if (bl) {
            lottieAnimationView.setSpeed(-1.0f);
        } else {
            lottieAnimationView.setSpeed(1.0f);
        }
        lottieAnimationView.playAnimation();
    }

    public static void animateTextSize(TextView textView, int n, int n2, long l) {
        if (textView == null) {
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)textView, (String)"textSize", (float[])new float[]{n, n2});
        objectAnimator.setDuration(l);
        objectAnimator.start();
    }

    public static void animateToTransparent(@NonNull View view, long l, int n) {
        AnimationUtils.animateToTransparent(view, l, n, null);
    }

    public static void animateToTransparent(final @NonNull View view, long l, final int n, final @Nullable AnimateToTransparentListener animateToTransparentListener) {
        AnimationUtils.animateAlpha(view, 1.0f, 0.0f, l, new OnAnimationEnd(){

            @Override
            public void onAnimationEnd(Animator animator) {
                view.setVisibility(n);
                if (animateToTransparentListener != null) {
                    animateToTransparentListener.onAnimationEnd();
                }
            }
        });
    }

    public static boolean areSystemAnimationsEnabled(@NonNull Context context) {
        float f2 = Build.VERSION.SDK_INT >= 17 ? Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f) : Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f);
        return f2 != 0.0f;
    }

    public static interface AnimateToTransparentListener {
        public void onAnimationEnd();
    }

    public static abstract class AnimationListenerAdapter
    implements Animation.AnimationListener {
        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    public static abstract class OnTransitionStart
    implements Transition.TransitionListener {
        public abstract void onTransitionStart(@NonNull Transition var1);

        public void onTransitionEnd(@NonNull Transition transition) {
        }

        public void onTransitionCancel(@NonNull Transition transition) {
        }

        public void onTransitionPause(@NonNull Transition transition) {
        }

        public void onTransitionResume(@NonNull Transition transition) {
        }
    }

    public static abstract class OnAnimationEnd
    implements Animator.AnimatorListener {
        public void onAnimationStart(Animator animator) {
        }

        public abstract void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }

    public static abstract class OnAnimationLoop
    implements Animator.AnimatorListener {
        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public abstract void onAnimationRepeat(Animator var1);
    }

    public static abstract class OnAnimationStart
    implements Animator.AnimatorListener {
        public abstract void onAnimationStart(Animator var1);

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }
}

