/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.commons.navigation;

import android.app.Activity;
import android.content.Intent;
import androidx.activity.ComponentActivity;
import androidx.annotation.CallSuper;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.yoti.mobile.android.commons.navigation.INavigationCoordinator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0004\u001a\u00020\u00118D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/yoti/mobile/android/commons/navigation/ActivityNavigationCoordinator;", "Lcom/yoti/mobile/android/commons/navigation/INavigationCoordinator;", "Landroidx/lifecycle/LifecycleObserver;", "Landroidx/activity/ComponentActivity;", "activity", "", "bind", "(Landroidx/activity/ComponentActivity;)V", "Landroid/content/Intent;", "intent", "navigateTo", "(Landroid/content/Intent;)V", "", "requestCode", "navigateForResult", "(Landroid/content/Intent;I)V", "resultIntent", "Landroid/app/Activity;", "finishWithResult", "(Landroid/content/Intent;)Landroid/app/Activity;", "clear", "()V", "getActivity", "()Landroid/app/Activity;", "a", "Landroid/app/Activity;", "_activity", "<init>", "commons-navigation_release"})
public abstract class ActivityNavigationCoordinator
implements INavigationCoordinator,
LifecycleObserver {
    private Activity a;

    @NotNull
    protected final Activity getActivity() {
        ActivityNavigationCoordinator activityNavigationCoordinator = activityNavigationCoordinator.a;
        if (activityNavigationCoordinator != null) {
            return activityNavigationCoordinator;
        }
        throw new IllegalArgumentException("No activity - coordinator may not be bound".toString());
    }

    @CallSuper
    public void bind(@NotNull ComponentActivity componentActivity) {
        ComponentActivity componentActivity2 = componentActivity;
        Intrinsics.checkNotNullParameter((Object)componentActivity2, (String)"activity");
        this.a = componentActivity2;
        componentActivity.getLifecycle().addObserver((LifecycleObserver)this);
    }

    protected final void navigateTo(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.getActivity().startActivity(intent);
    }

    protected final void navigateForResult(@NotNull Intent intent, int n) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.getActivity().startActivityForResult(intent, n);
    }

    @NotNull
    protected final Activity finishWithResult(@Nullable Intent intent) {
        Activity activity = this.getActivity();
        activity.setResult(-1, intent);
        activity.finish();
        return activity;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void clear() {
        this.a = null;
    }
}

