/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.commons.navigation;

import android.content.Intent;
import androidx.annotation.CallSuper;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.yoti.mobile.android.commons.navigation.INavigationCoordinator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0010J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0005H\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u00020\u00038D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/yoti/mobile/android/commons/navigation/FragmentNavigationCoordinator;", "Lcom/yoti/mobile/android/commons/navigation/INavigationCoordinator;", "Landroidx/lifecycle/LifecycleObserver;", "Landroidx/fragment/app/Fragment;", "fragment", "", "fragmentContainerId", "", "bind", "(Landroidx/fragment/app/Fragment;I)V", "Landroid/content/Intent;", "intent", "requestCode", "navigateForResult", "(Landroid/content/Intent;I)V", "clear", "()V", "getFragment", "()Landroidx/fragment/app/Fragment;", "a", "Landroidx/fragment/app/Fragment;", "_fragment", "<init>", "commons-navigation_release"})
public abstract class FragmentNavigationCoordinator
implements INavigationCoordinator,
LifecycleObserver {
    private Fragment a;

    @NotNull
    protected final Fragment getFragment() {
        FragmentNavigationCoordinator fragmentNavigationCoordinator = fragmentNavigationCoordinator.a;
        if (fragmentNavigationCoordinator != null) {
            return fragmentNavigationCoordinator;
        }
        throw new IllegalArgumentException("No fragment - coordinator may not be bound".toString());
    }

    @CallSuper
    public void bind(@NotNull Fragment fragment, int n) {
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"fragment");
        this.a = fragment2;
        LifecycleOwner lifecycleOwner = fragment.getViewLifecycleOwner();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycleOwner, (String)"fragment.viewLifecycleOwner");
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
    }

    protected final void navigateForResult(@NotNull Intent intent, int n) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.getFragment().startActivityForResult(intent, n);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void clear() {
        this.a = null;
    }
}

