/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.commons.navigation;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.navigation.ActivityKt;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import com.yoti.mobile.android.commons.navigation.INavigationCoordinator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b!\u0010\u0014J!\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001e\u001a\u00020\u00158D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0004\u001a\u00020\u00108D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/yoti/mobile/android/commons/navigation/NavHostActivityNavigationCoordinator;", "Lcom/yoti/mobile/android/commons/navigation/INavigationCoordinator;", "Landroidx/lifecycle/LifecycleObserver;", "Landroidx/activity/ComponentActivity;", "activity", "", "navHostId", "", "bind", "(Landroidx/activity/ComponentActivity;I)V", "Lkotlin/Function1;", "listener", "registerNavigationListener", "(Lkotlin/jvm/functions/Function1;)V", "Landroid/content/Intent;", "resultIntent", "Landroid/app/Activity;", "finishWithResult", "(Landroid/content/Intent;)Landroid/app/Activity;", "clear", "()V", "Landroidx/navigation/NavController;", "a", "Landroidx/navigation/NavController;", "_navController", "b", "Landroid/app/Activity;", "_activity", "getNavController", "()Landroidx/navigation/NavController;", "navController", "getActivity", "()Landroid/app/Activity;", "<init>", "commons-navigation_release"})
public abstract class NavHostActivityNavigationCoordinator
implements INavigationCoordinator,
LifecycleObserver {
    private NavController a;
    private Activity b;

    @NotNull
    protected final NavController getNavController() {
        NavHostActivityNavigationCoordinator navHostActivityNavigationCoordinator = navHostActivityNavigationCoordinator.a;
        if (navHostActivityNavigationCoordinator != null) {
            return navHostActivityNavigationCoordinator;
        }
        throw new IllegalArgumentException("No nav controller - coordinator may not be bound".toString());
    }

    @NotNull
    protected final Activity getActivity() {
        NavHostActivityNavigationCoordinator navHostActivityNavigationCoordinator = navHostActivityNavigationCoordinator.b;
        if (navHostActivityNavigationCoordinator != null) {
            return navHostActivityNavigationCoordinator;
        }
        throw new IllegalArgumentException("No activity - coordinator may not be bound".toString());
    }

    @CallSuper
    public void bind(@NotNull ComponentActivity componentActivity, @IdRes int n) {
        ComponentActivity componentActivity2 = componentActivity;
        Intrinsics.checkNotNullParameter((Object)componentActivity2, (String)"activity");
        this.b = componentActivity2;
        this.a = ActivityKt.findNavController((Activity)componentActivity, (int)n);
        componentActivity.getLifecycle().addObserver((LifecycleObserver)this);
    }

    public final void registerNavigationListener(final @NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        this.getNavController().addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(){

            public final void onDestinationChanged(@NotNull NavController navController, @NotNull NavDestination navDestination, @Nullable Bundle bundle) {
                Intrinsics.checkNotNullParameter((Object)navController, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)navDestination, (String)"destination");
                function1.invoke((Object)navDestination.getId());
            }
        });
    }

    @NotNull
    protected final Activity finishWithResult(@Nullable Intent intent) {
        Activity activity = this.getActivity();
        activity.setResult(-1, intent);
        activity.finish();
        return activity;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void clear() {
        NavHostActivityNavigationCoordinator navHostActivityNavigationCoordinator = this;
        navHostActivityNavigationCoordinator.a = null;
        navHostActivityNavigationCoordinator.b = null;
    }
}

