/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.documentscan.ui.helpers.scan;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.res.ResourcesCompat;
import com.yoti.mobile.android.documentscan.R;
import com.yoti.mobile.android.documentscan.ui.helpers.scan.IScanFrameShape;

public class DocumentScanOverlayView
extends View {
    private static final float TEXT_HORIZONTAL_MARGIN_PCT = 0.05f;
    @StringRes
    private int mTitleTextRes;
    @StringRes
    private int mMessageTextRes;
    private Paint mBackgroundPaint;
    private RectF mDocumentRect;
    private IScanFrameShape mCornerPath;
    private float mDocumentRatio;
    private boolean mActiveState;
    private float scanRectMarginTop;
    private float scanRectMarginBottom;
    private float scanRectMarginHorizontal;
    private TextPaint mTitleTextPaint;
    private TextPaint mMessageTextPaint;
    private Layout mTitleTextLayout;
    private Layout mMessageTextLayout;
    private int mTitleTextExpectedSize;
    private int mMessageTextExpectedSize;
    private float mMessageTextSpacing;
    private RectF mTitleTextBounds;
    private RectF mMessageTextBounds;

    public DocumentScanOverlayView(Context context) {
        DocumentScanOverlayView documentScanOverlayView = this;
        super(context);
        documentScanOverlayView.mDocumentRect = new RectF();
        documentScanOverlayView.scanRectMarginTop = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginBottom = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginHorizontal = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_horizontal_margin);
        documentScanOverlayView.mTitleTextBounds = new RectF();
        documentScanOverlayView.mMessageTextBounds = new RectF();
        documentScanOverlayView.init();
    }

    public DocumentScanOverlayView(Context context, @Nullable AttributeSet attributeSet) {
        DocumentScanOverlayView documentScanOverlayView = this;
        super(context, attributeSet);
        documentScanOverlayView.mDocumentRect = new RectF();
        documentScanOverlayView.scanRectMarginTop = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginBottom = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginHorizontal = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_horizontal_margin);
        documentScanOverlayView.mTitleTextBounds = new RectF();
        documentScanOverlayView.mMessageTextBounds = new RectF();
        documentScanOverlayView.init();
    }

    public DocumentScanOverlayView(Context context, @Nullable AttributeSet attributeSet, int n2) {
        DocumentScanOverlayView documentScanOverlayView = this;
        super(context, attributeSet, n2);
        documentScanOverlayView.mDocumentRect = new RectF();
        documentScanOverlayView.scanRectMarginTop = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginBottom = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_vertical_margin);
        documentScanOverlayView.scanRectMarginHorizontal = documentScanOverlayView.getResources().getDimension(R.dimen.document_reader_scan_horizontal_margin);
        documentScanOverlayView.mTitleTextBounds = new RectF();
        documentScanOverlayView.mMessageTextBounds = new RectF();
        documentScanOverlayView.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        DocumentScanOverlayView documentScanOverlayView = this;
        documentScanOverlayView.mBackgroundPaint = new Paint(1);
        documentScanOverlayView.mBackgroundPaint.setStyle(Paint.Style.FILL);
        int n2 = ResourcesCompat.getColor((Resources)documentScanOverlayView.getResources(), (int)R.color.yoti_white, null);
        documentScanOverlayView.mTitleTextExpectedSize = documentScanOverlayView.getResources().getDimensionPixelSize(R.dimen.yoti_document_reader_title_size);
        documentScanOverlayView.mTitleTextPaint = new TextPaint();
        documentScanOverlayView.mTitleTextPaint.setColor(n2);
        documentScanOverlayView.mTitleTextPaint.setStyle(Paint.Style.FILL);
        documentScanOverlayView.mTitleTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        documentScanOverlayView.mTitleTextPaint.setTextSize((float)this.mTitleTextExpectedSize);
        documentScanOverlayView.mTitleTextPaint.setTextAlign(Paint.Align.CENTER);
        documentScanOverlayView.mMessageTextExpectedSize = documentScanOverlayView.getResources().getDimensionPixelSize(R.dimen.yoti_document_reader_text_size);
        documentScanOverlayView.mMessageTextPaint = new TextPaint();
        documentScanOverlayView.mMessageTextPaint.setColor(n2);
        documentScanOverlayView.mMessageTextPaint.setStyle(Paint.Style.FILL);
        documentScanOverlayView.mMessageTextPaint.setTextSize((float)this.mMessageTextExpectedSize);
        documentScanOverlayView.mMessageTextPaint.setTextAlign(Paint.Align.CENTER);
        documentScanOverlayView.mMessageTextSpacing = documentScanOverlayView.getResources().getDimensionPixelSize(R.dimen.yoti_document_reader_text_spacing);
    }

    private void resolveWindowSize(int n2, int n3, int n4, int n5, float f2) {
        float f3 = n4 - n2;
        float f4 = f3 - this.scanRectMarginHorizontal * 2.0f;
        float f5 = f4 * f2;
        while (f5 + this.scanRectMarginTop > (float)this.getHeight() - this.scanRectMarginBottom) {
            DocumentScanOverlayView documentScanOverlayView = this;
            documentScanOverlayView.scanRectMarginHorizontal += 1.0f;
            f4 = f3 - documentScanOverlayView.scanRectMarginHorizontal * 2.0f;
            f5 = f4 * f2;
        }
        DocumentScanOverlayView documentScanOverlayView = this;
        float f6 = n2;
        f3 = this.scanRectMarginHorizontal;
        float f7 = n3;
        f2 = this.scanRectMarginTop;
        documentScanOverlayView.mDocumentRect.set(f6 + f3, f7 + f2, f6 + f3 + f4, f7 + f2 + f5);
        RectF rectF = documentScanOverlayView.mDocumentRect;
        float f8 = rectF.top + rectF.height() / 2.0f;
        RectF rectF2 = this.mDocumentRect;
        documentScanOverlayView.mTitleTextBounds.set(rectF2.left, rectF2.top, rectF2.right, f8);
        rectF2 = this.mDocumentRect;
        documentScanOverlayView.mMessageTextBounds.set(rectF2.left, f8, rectF2.right, rectF2.bottom);
        f8 = documentScanOverlayView.mMessageTextBounds.width() * 0.05f;
        documentScanOverlayView.mMessageTextBounds.inset(f8, 0.0f);
        documentScanOverlayView.mCornerPath.setCorners(this.mDocumentRect);
        documentScanOverlayView.measureTitleText();
        documentScanOverlayView.measureMessageText();
        documentScanOverlayView.postInvalidate();
    }

    private void measureTitleText() {
        if (this.mTitleTextBounds.width() != 0.0f && this.mTitleTextBounds.height() != 0.0f && this.mTitleTextRes != 0) {
            DocumentScanOverlayView documentScanOverlayView = this;
            documentScanOverlayView.mTitleTextLayout = documentScanOverlayView.scaleTextPaint(documentScanOverlayView.mTitleTextPaint, this.getResources().getString(this.mTitleTextRes), this.mTitleTextExpectedSize, this.mTitleTextBounds, false);
            return;
        }
    }

    private void measureMessageText() {
        if (this.mMessageTextBounds.width() != 0.0f && this.mMessageTextBounds.height() != 0.0f && this.mTitleTextRes != 0) {
            DocumentScanOverlayView documentScanOverlayView = this;
            documentScanOverlayView.mMessageTextLayout = documentScanOverlayView.scaleTextPaint(documentScanOverlayView.mMessageTextPaint, this.getResources().getString(this.mMessageTextRes), this.mMessageTextExpectedSize, this.mMessageTextBounds, true);
            return;
        }
    }

    private Layout scaleTextPaint(TextPaint textPaint, String string, int n2, RectF rectF, boolean n3) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new StaticLayout((CharSequence)string, textPaint, (int)rectF.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        int n4 = n3;
        n3 = Integer.MAX_VALUE;
        if (n4 == 0) {
            n3 = string.split("\\n").length;
        }
        while (n2 > 0) {
            StaticLayout staticLayout;
            textPaint.setTextSize((float)n2);
            StaticLayout staticLayout2 = staticLayout;
            if (new StaticLayout((CharSequence)string, textPaint, (int)rectF.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, this.mMessageTextSpacing, false).getLineCount() <= n3 && rectF.width() >= (float)staticLayout2.getWidth() && rectF.height() >= (float)staticLayout2.getHeight()) {
                return staticLayout2;
            }
            --n2;
        }
        return new StaticLayout((CharSequence)string, textPaint, (int)rectF.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, this.mMessageTextSpacing, false);
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        float f2;
        DocumentScanOverlayView documentScanOverlayView = this;
        super.onLayout(bl, n2, n3, n4, n5);
        float f3 = documentScanOverlayView.mDocumentRatio;
        if (f2 > 0.0f) {
            this.resolveWindowSize(n2, n3, n4, n5, f3);
        }
    }

    public void setScanFrameShape(IScanFrameShape iScanFrameShape) {
        this.mCornerPath = iScanFrameShape;
        this.mCornerPath.deactivate();
    }

    public void setBackground(@ColorRes Integer n2) {
        this.mBackgroundPaint.setColor(ResourcesCompat.getColor((Resources)this.getResources(), (int)n2, null));
    }

    public void setScanFrameMargins(float f2, float f3, float f4) {
        this.scanRectMarginTop = f2;
        this.scanRectMarginBottom = f3;
        this.scanRectMarginHorizontal = f4;
    }

    public void setDocumentRatio(float f2) {
        DocumentScanOverlayView documentScanOverlayView = this;
        documentScanOverlayView.mDocumentRatio = f2;
        documentScanOverlayView.mCornerPath.setRatio(f2);
        if (documentScanOverlayView.getWidth() > 0) {
            DocumentScanOverlayView documentScanOverlayView2 = this;
            documentScanOverlayView2.resolveWindowSize(documentScanOverlayView2.getLeft(), this.getTop(), this.getRight(), this.getBottom(), f2);
        }
    }

    public void setOverlayMessage(@StringRes int n2, @StringRes int n3) {
        Rect rect;
        DocumentScanOverlayView documentScanOverlayView = this;
        this.mTitleTextRes = n2;
        documentScanOverlayView.mMessageTextRes = n3;
        documentScanOverlayView.measureTitleText();
        documentScanOverlayView.measureMessageText();
        Rect rect2 = rect;
        rect2();
        this.mDocumentRect.round(rect2);
        documentScanOverlayView.invalidate(rect);
    }

    public void setActive(boolean bl) {
        if (this.mActiveState == bl) {
            return;
        }
        this.mActiveState = bl;
        if (bl) {
            this.mCornerPath.activate();
        } else {
            this.mCornerPath.deactivate();
        }
        this.postInvalidate();
    }

    public RectF getScanWindowPosition() {
        return this.mDocumentRect;
    }

    protected void onDraw(Canvas canvas) {
        DocumentScanOverlayView documentScanOverlayView = this;
        super.onDraw(canvas);
        if (documentScanOverlayView.mDocumentRect != null) {
            Canvas canvas2 = canvas;
            canvas.save();
            canvas.clipPath(this.mCornerPath.getShape(), Region.Op.DIFFERENCE);
            canvas2.drawPaint(this.mBackgroundPaint);
            canvas2.restore();
            if (this.mTitleTextLayout != null) {
                canvas.save();
                canvas.translate(this.mTitleTextBounds.centerX(), this.mTitleTextBounds.centerY() - (float)(this.mTitleTextLayout.getHeight() / 2));
                this.mTitleTextLayout.draw(canvas);
                canvas.restore();
            }
            if (this.mMessageTextLayout != null) {
                canvas.save();
                canvas.translate(this.mMessageTextBounds.centerX(), this.mMessageTextBounds.top);
                this.mMessageTextLayout.draw(canvas);
                canvas.restore();
            }
            this.mCornerPath.draw(canvas);
        }
    }
}

