/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.mobile.android.documentscan.ui.helpers.scan;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.ColorRes;
import androidx.core.content.res.ResourcesCompat;
import com.yoti.mobile.android.documentscan.R;
import com.yoti.mobile.android.documentscan.ui.helpers.scan.IScanFrameShape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u001c\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/yoti/mobile/android/documentscan/ui/helpers/scan/RoundedCornerRectangleFrameShape;", "Lcom/yoti/mobile/android/documentscan/ui/helpers/scan/IScanFrameShape;", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "cornerRadius", "", "paint", "Landroid/graphics/Paint;", "shape", "Landroid/graphics/Path;", "window", "Landroid/graphics/RectF;", "activate", "", "deactivate", "draw", "canvas", "Landroid/graphics/Canvas;", "getShape", "setCorners", "windowRect", "setGradient", "colorStart", "", "colorEnd", "setRatio", "ratio", "documentscan_release"})
public final class RoundedCornerRectangleFrameShape
implements IScanFrameShape {
    private final Path shape;
    private final Paint paint;
    private RectF window;
    private final float cornerRadius;
    private final Resources resources;

    private final void setGradient(@ColorRes int n2, @ColorRes int n3) {
        RectF rectF = this.window;
        float f2 = rectF != null ? rectF.right : 0.0f;
        RoundedCornerRectangleFrameShape roundedCornerRectangleFrameShape = this;
        int n4 = ResourcesCompat.getColor((Resources)roundedCornerRectangleFrameShape.resources, (int)n2, null);
        n2 = ResourcesCompat.getColor((Resources)roundedCornerRectangleFrameShape.resources, (int)n3, null);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        this.paint.setShader((Shader)new LinearGradient(0.0f, 0.0f, f2, 0.0f, n4, n2, tileMode));
    }

    public RoundedCornerRectangleFrameShape(@NotNull Resources resources) {
        RoundedCornerRectangleFrameShape roundedCornerRectangleFrameShape = this;
        Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
        roundedCornerRectangleFrameShape.resources = resources;
        roundedCornerRectangleFrameShape.shape = new Path();
        roundedCornerRectangleFrameShape.paint = new Paint(1);
        roundedCornerRectangleFrameShape.cornerRadius = roundedCornerRectangleFrameShape.resources.getDimension(R.dimen.document_reader_scan_corners_rounding_v2);
        roundedCornerRectangleFrameShape.paint.setStyle(Paint.Style.STROKE);
        roundedCornerRectangleFrameShape.paint.setStrokeWidth(this.resources.getDimension(R.dimen.document_reader_scan_border_width_v2));
        roundedCornerRectangleFrameShape.paint.setPathEffect((PathEffect)new CornerPathEffect(this.cornerRadius));
    }

    @Override
    public void activate() {
        this.setGradient(R.color.yoti_document_reader_guide_lines_detection_gradient_start_v2, R.color.yoti_document_reader_guide_lines_detection_gradient_end_v2);
    }

    @Override
    public void deactivate() {
        this.setGradient(R.color.yoti_document_reader_guide_lines_gradient_start_v2, R.color.yoti_document_reader_guide_lines_gradient_end_v2);
    }

    @Override
    public void setRatio(float f2) {
    }

    @Override
    public void setCorners(@NotNull RectF rectF) {
        RectF rectF2 = rectF;
        Intrinsics.checkParameterIsNotNull((Object)rectF2, (String)"windowRect");
        this.window = rectF2;
        float f2 = this.cornerRadius;
        this.shape.addRoundRect(rectF.left, rectF.top, rectF.right, rectF.bottom, f2, f2, Path.Direction.CW);
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        RectF rectF = this.window;
        if (rectF != null) {
            canvas.drawRect(rectF, this.paint);
        }
    }

    @Override
    @NotNull
    public Path getShape() {
        return this.shape;
    }
}

