/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.ApplicationProfile;
import com.yoti.api.client.ExtraData;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.Date;
import org.bouncycastle.util.encoders.Base64;

public final class ActivityDetails {
    private final String rememberMeId;
    private final String parentRememberMeId;
    private final ApplicationProfile applicationProfile;
    private final HumanProfile userProfile;
    private final Date timestamp;
    private final String receiptId;
    private final ExtraData extraData;

    public ActivityDetails(String rememberMeId, String parentRememberMeId, HumanProfile userProfile, ApplicationProfile applicationProfile, ExtraData extraData, Date timestamp, byte[] receiptId) {
        this.rememberMeId = Validation.notNull(rememberMeId, "Remember Me id");
        this.parentRememberMeId = parentRememberMeId;
        this.userProfile = Validation.notNull(userProfile, "User profile");
        this.applicationProfile = Validation.notNull(applicationProfile, "Application profile");
        this.timestamp = Validation.notNull(timestamp, "Timestamp");
        this.receiptId = Base64.toBase64String((byte[])Validation.notNull(receiptId, "Receipt id"));
        this.extraData = Validation.notNull(extraData, "extraData");
    }

    public HumanProfile getUserProfile() {
        return this.userProfile;
    }

    public ApplicationProfile getApplicationProfile() {
        return this.applicationProfile;
    }

    public String getRememberMeId() {
        return this.rememberMeId;
    }

    public String getParentRememberMeId() {
        return this.parentRememberMeId;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public ExtraData getExtraData() {
        return this.extraData;
    }
}

