/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;

abstract class AutoClosingKeyPairSource
implements KeyPairSource {
    private boolean closed = false;

    AutoClosingKeyPairSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final KeyPair getFromStream(KeyPairSource.StreamVisitor streamVisitor) throws IOException, InitialisationException {
        KeyPair keyPair = null;
        if (this.closed) {
            throw new IllegalStateException("Stream already closed");
        }
        try {
            keyPair = streamVisitor.accept(this.getStream());
        }
        finally {
            if (this.shouldClose()) {
                try {
                    this.getStream().close();
                }
                catch (IOException iOException) {}
                this.closed = true;
            }
        }
        return keyPair;
    }

    protected abstract InputStream getStream();

    protected boolean shouldClose() {
        return true;
    }
}

