/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.Date;
import com.yoti.api.client.Time;
import com.yoti.api.client.spi.remote.util.Validation;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTime {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private final Date date;
    private final Time time;

    public DateTime(Date date, Time time) {
        Validation.notNull(date, "date");
        Validation.notNull(time, "time");
        this.date = date;
        this.time = time;
    }

    public static DateTime from(long microseconds) {
        Calendar calendar = GregorianCalendar.getInstance(UTC_TIME_ZONE);
        int mod = (int)(microseconds % 1000L);
        long milliseconds = (microseconds - (long)mod) / 1000L;
        calendar.setTimeInMillis(milliseconds);
        return new DateTime(Date.from(calendar), Time.from(calendar, mod));
    }

    public static DateTime from(String dateTimeStringValue) throws DateTimeParseException {
        OffsetDateTime zonedDateTime = OffsetDateTime.parse(dateTimeStringValue).truncatedTo(ChronoUnit.MICROS);
        return DateTime.from(ChronoUnit.MICROS.between(Instant.EPOCH, zonedDateTime.toInstant()));
    }

    public Date getDate() {
        return this.date;
    }

    public Time getTime() {
        return this.time;
    }

    public String toString() {
        return String.format("DateTime{date=%s,time=%s}", this.date, this.time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime that = (DateTime)o;
        return this.date.equals(that.getDate()) && this.time.equals(that.getTime());
    }

    public int hashCode() {
        int result = this.date != null ? this.date.hashCode() : 0;
        result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
        return result;
    }
}

