/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.AutoClosingKeyPairSource;
import com.yoti.api.client.InitialisationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileKeyPairSource
extends AutoClosingKeyPairSource {
    private final InputStream stream;
    private final String asString;

    public static FileKeyPairSource fromFile(File file) throws InitialisationException {
        return new FileKeyPairSource(file);
    }

    private FileKeyPairSource(File file) throws InitialisationException {
        this.asString = "file: " + file.getAbsolutePath();
        try {
            this.stream = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new InitialisationException("Cannot open keypair from file: " + file, e);
        }
    }

    @Override
    protected InputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return this.asString;
    }
}

