/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.AgeVerification;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import com.yoti.api.client.Image;
import com.yoti.api.client.Profile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HumanProfile
extends Profile {
    public static final String GENDER_MALE = "MALE";
    public static final String GENDER_FEMALE = "FEMALE";
    public static final String GENDER_TRANSGENDER = "TRANSGENDER";
    public static final String GENDER_OTHER = "OTHER";
    private Map<String, AgeVerification> verificationsMap;

    public HumanProfile(List<Attribute<?>> attributeList) {
        super(attributeList);
    }

    public Attribute<String> getFamilyName() {
        return this.getAttribute("family_name", String.class);
    }

    public Attribute<String> getGivenNames() {
        return this.getAttribute("given_names", String.class);
    }

    public Attribute<String> getFullName() {
        return this.getAttribute("full_name", String.class);
    }

    public Attribute<Date> getDateOfBirth() {
        return this.getAttribute("date_of_birth", Date.class);
    }

    public List<AgeVerification> getAgeVerifications() {
        this.findAllAgeVerifications();
        return Collections.unmodifiableList(new ArrayList<AgeVerification>(this.verificationsMap.values()));
    }

    public AgeVerification findAgeOverVerification(int age) {
        this.findAllAgeVerifications();
        return this.verificationsMap.get("age_over:" + age);
    }

    public AgeVerification findAgeUnderVerification(int age) {
        this.findAllAgeVerifications();
        return this.verificationsMap.get("age_under:" + age);
    }

    private void findAllAgeVerifications() {
        if (this.verificationsMap == null) {
            HashMap<String, AgeVerification> verifications = new HashMap<String, AgeVerification>();
            for (Attribute<String> ageOver : this.findAttributesStartingWith("age_over:", String.class)) {
                verifications.put(ageOver.getName(), new AgeVerification(ageOver));
            }
            for (Attribute<String> ageUnder : this.findAttributesStartingWith("age_under:", String.class)) {
                verifications.put(ageUnder.getName(), new AgeVerification(ageUnder));
            }
            this.verificationsMap = verifications;
        }
    }

    public Attribute<String> getGender() {
        return this.getAttribute("gender", String.class);
    }

    public Attribute<String> getPostalAddress() {
        return this.getAttribute("postal_address", String.class);
    }

    public Attribute<Map<?, ?>> getStructuredPostalAddress() {
        return this.getAttribute("structured_postal_address", Map.class);
    }

    public Attribute<String> getNationality() {
        return this.getAttribute("nationality", String.class);
    }

    public Attribute<String> getPhoneNumber() {
        return this.getAttribute("phone_number", String.class);
    }

    public Attribute<Image> getSelfie() {
        return this.getAttribute("selfie", Image.class);
    }

    public Attribute<String> getEmailAddress() {
        return this.getAttribute("email_address", String.class);
    }

    public Attribute<DocumentDetails> getDocumentDetails() {
        return this.getAttribute("document_details", DocumentDetails.class);
    }

    public Attribute<List<Image>> getDocumentImages() {
        Attribute<List<Image>> a = this.getAttribute("document_images", List.class);
        return a;
    }
}

