/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Profile {
    private final Map<String, List<Attribute<?>>> protectedAttributes;

    Profile(List<Attribute<?>> attributeList) {
        if (attributeList == null) {
            throw new IllegalArgumentException("Attributes must not be null.");
        }
        this.protectedAttributes = Collections.unmodifiableMap(this.createAttributeMap(attributeList));
    }

    public <T> Attribute<T> getAttribute(String name, Class<T> clazz) {
        Attribute<?> attribute = this.getAttribute(name);
        return this.castSafely(clazz, attribute);
    }

    public Attribute<?> getAttribute(String name) {
        this.ensureName(name);
        List<Attribute<?>> attributes = this.protectedAttributes.get(name);
        if (attributes != null && attributes.size() > 0) {
            return attributes.get(0);
        }
        return null;
    }

    public <T> List<Attribute<T>> findAttributesStartingWith(String name, Class<T> clazz) {
        this.ensureName(name);
        ArrayList<Attribute<T>> matches = new ArrayList<Attribute<T>>();
        for (Map.Entry<String, List<Attribute<?>>> entry : this.protectedAttributes.entrySet()) {
            if (!entry.getKey().startsWith(name)) continue;
            for (Attribute<?> attribute : entry.getValue()) {
                Attribute<T> value = this.castSafely(clazz, attribute);
                matches.add(value);
            }
        }
        return matches;
    }

    public <T> Attribute<T> findAttributeStartingWith(String name, Class<T> clazz) {
        this.ensureName(name);
        Attribute<?> attribute = this.findAttributeStartingWith(name);
        return this.castSafely(clazz, attribute);
    }

    private Attribute<?> findAttributeStartingWith(String name) {
        this.ensureName(name);
        for (Map.Entry<String, List<Attribute<?>>> entry : this.protectedAttributes.entrySet()) {
            if (!entry.getKey().startsWith(name)) continue;
            return entry.getValue().get(0);
        }
        return null;
    }

    public Collection<Attribute<?>> getAttributes() {
        ArrayList attributes = new ArrayList();
        for (Map.Entry<String, List<Attribute<?>>> entry : this.protectedAttributes.entrySet()) {
            attributes.addAll((Collection)entry.getValue());
        }
        return attributes;
    }

    private Map<String, List<Attribute<?>>> createAttributeMap(List<Attribute<?>> attributes) {
        HashMap result = new HashMap();
        for (Attribute<?> a : attributes) {
            if (!result.containsKey(a.getName())) {
                result.put(a.getName(), new ArrayList());
            }
            List modifiable = (List)result.get(a.getName());
            modifiable.add(a);
            result.put(a.getName(), modifiable);
        }
        return result;
    }

    private void ensureName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null.");
        }
    }

    private <T> Attribute<T> castSafely(Class<T> clazz, Attribute<?> attribute) {
        Class<?> valueType;
        if (attribute != null && !clazz.isAssignableFrom(valueType = attribute.getValue().getClass())) {
            throw new ClassCastException(String.format("Cannot cast from '%s' to '%s'", valueType.getCanonicalName(), clazz.getCanonicalName()));
        }
        return attribute;
    }
}

