/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.spi.remote.util.Validation;
import java.util.Calendar;

public class Time {
    private final int hour;
    private final int minute;
    private final int second;
    private final int microsecond;

    private Time(int hour, int minute, int second, int microsecond) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
    }

    public static Time from(Calendar calendar, int microsecond) {
        Validation.notGreaterThan(microsecond, 999, "microsecond");
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000 + microsecond);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%06d", this.hour, this.minute, this.second, this.microsecond);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Time timeValue = (Time)o;
        if (this.hour != timeValue.getHour()) {
            return false;
        }
        if (this.minute != timeValue.getMinute()) {
            return false;
        }
        if (this.second != timeValue.getSecond()) {
            return false;
        }
        return this.microsecond == timeValue.getMicrosecond();
    }

    public int hashCode() {
        int result = this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.second;
        result = 31 * result + this.microsecond;
        return result;
    }

    public static TimeBuilder builder() {
        return new TimeBuilder();
    }

    public static class TimeBuilder {
        private int hour;
        private int minute;
        private int second;
        private int microsecond;

        private TimeBuilder() {
        }

        public TimeBuilder withHour(int hour) {
            Validation.withinRange(hour, 0, 23, "hour");
            this.hour = hour;
            return this;
        }

        public TimeBuilder withMinute(int minute) {
            Validation.withinRange(minute, 0, 59, "minute");
            this.minute = minute;
            return this;
        }

        public TimeBuilder withSecond(int second) {
            Validation.withinRange(second, 0, 59, "second");
            this.second = second;
            return this;
        }

        public TimeBuilder withMicrosecond(int microsecond) {
            Validation.withinRange(microsecond, 0, 999999, "microsecond");
            this.microsecond = microsecond;
            return this;
        }

        public Time build() {
            return new Time(this.hour, this.minute, this.second, this.microsecond);
        }
    }
}

