/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.ActivityDetails;
import com.yoti.api.client.AmlException;
import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.aml.AmlProfile;
import com.yoti.api.client.aml.AmlResult;
import com.yoti.api.client.shareurl.DynamicScenario;
import com.yoti.api.client.shareurl.DynamicShareException;
import com.yoti.api.client.shareurl.ShareUrlResult;
import com.yoti.api.client.spi.remote.ActivityDetailsFactory;
import com.yoti.api.client.spi.remote.KeyStreamVisitor;
import com.yoti.api.client.spi.remote.ReceiptFetcher;
import com.yoti.api.client.spi.remote.call.Receipt;
import com.yoti.api.client.spi.remote.call.aml.RemoteAmlService;
import com.yoti.api.client.spi.remote.call.qrcode.DynamicSharingService;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YotiClient {
    private static final Logger LOG = LoggerFactory.getLogger(YotiClient.class);
    private final String appId;
    private final KeyPair keyPair;
    private final ReceiptFetcher receiptFetcher;
    private final RemoteAmlService remoteAmlService;
    private final ActivityDetailsFactory activityDetailsFactory;
    private final DynamicSharingService dynamicSharingService;

    YotiClient(String applicationId, KeyPairSource kpSource, ReceiptFetcher receiptFetcher, ActivityDetailsFactory activityDetailsFactory, RemoteAmlService remoteAmlService, DynamicSharingService dynamicSharingService) throws InitialisationException {
        this.appId = Validation.notNull(applicationId, "Application id");
        this.keyPair = this.loadKeyPair(Validation.notNull(kpSource, "Key pair source"));
        this.receiptFetcher = Validation.notNull(receiptFetcher, "receiptFetcher");
        this.remoteAmlService = Validation.notNull(remoteAmlService, "amlService");
        this.activityDetailsFactory = Validation.notNull(activityDetailsFactory, "activityDetailsFactory");
        this.dynamicSharingService = Validation.notNull(dynamicSharingService, "QR Code service");
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActivityDetails getActivityDetails(String encryptedYotiToken) throws ProfileException {
        Receipt receipt = this.receiptFetcher.fetch(encryptedYotiToken, this.keyPair, this.appId);
        return this.activityDetailsFactory.create(receipt, this.keyPair.getPrivate());
    }

    public AmlResult performAmlCheck(AmlProfile amlProfile) throws AmlException {
        LOG.debug("Performing aml check...");
        return this.remoteAmlService.performCheck(this.keyPair, this.appId, amlProfile);
    }

    public ShareUrlResult createShareUrl(DynamicScenario dynamicScenario) throws DynamicShareException {
        LOG.debug("Request a share url for a dynamicScenario...");
        return this.dynamicSharingService.createShareUrl(this.appId, this.keyPair, dynamicScenario);
    }

    private KeyPair loadKeyPair(KeyPairSource kpSource) throws InitialisationException {
        try {
            LOG.debug("Loading key pair from '{}'", (Object)kpSource);
            return kpSource.getFromStream(new KeyStreamVisitor());
        }
        catch (IOException e) {
            throw new InitialisationException("Cannot load key pair", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class Builder {
        private String sdkId;
        private KeyPairSource keyPairSource;

        private Builder() {
        }

        public Builder withClientSdkId(String sdkId) {
            this.sdkId = sdkId;
            return this;
        }

        public Builder withKeyPair(KeyPairSource keyPairSource) {
            this.keyPairSource = keyPairSource;
            return this;
        }

        public YotiClient build() {
            this.checkBuilderState();
            return new YotiClient(this.sdkId, this.keyPairSource, ReceiptFetcher.newInstance(), ActivityDetailsFactory.newInstance(), RemoteAmlService.newInstance(), DynamicSharingService.newInstance());
        }

        private void checkBuilderState() {
            if (this.keyPairSource == null) {
                throw new IllegalStateException("No key pair supplied");
            }
            if (this.sdkId == null) {
                throw new IllegalStateException("No SDK ID supplied");
            }
        }
    }
}

