/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs;

import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import com.yoti.api.client.Media;
import com.yoti.api.client.docs.DocScanException;
import com.yoti.api.client.docs.DocScanService;
import com.yoti.api.client.docs.session.create.CreateSessionResult;
import com.yoti.api.client.docs.session.create.SessionSpec;
import com.yoti.api.client.docs.session.retrieve.GetSessionResult;
import com.yoti.api.client.docs.support.SupportedDocumentsResponse;
import com.yoti.api.client.spi.remote.KeyStreamVisitor;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocScanClient {
    private static final Logger LOG = LoggerFactory.getLogger(DocScanClient.class);
    private final String sdkId;
    private final KeyPair keyPair;
    private final DocScanService docScanService;

    DocScanClient(String sdkId, KeyPairSource keyPairSource, DocScanService docScanService) {
        this.sdkId = sdkId;
        this.keyPair = this.loadKeyPair(keyPairSource);
        this.docScanService = docScanService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateSessionResult createSession(SessionSpec sessionSpec) throws DocScanException {
        LOG.debug("Creating a YotiDocs session...");
        return this.docScanService.createSession(this.sdkId, this.keyPair, sessionSpec);
    }

    public GetSessionResult getSession(String sessionId) throws DocScanException {
        LOG.debug("Retrieving session '{}'", (Object)sessionId);
        return this.docScanService.retrieveSession(this.sdkId, this.keyPair, sessionId);
    }

    public void deleteSession(String sessionId) throws DocScanException {
        LOG.debug("Deleting session '{}'", (Object)sessionId);
        this.docScanService.deleteSession(this.sdkId, this.keyPair, sessionId);
    }

    public Media getMediaContent(String sessionId, String mediaId) throws DocScanException {
        LOG.debug("Retrieving media content '{}' in session '{}'", (Object)mediaId, (Object)sessionId);
        return this.docScanService.getMediaContent(this.sdkId, this.keyPair, sessionId, mediaId);
    }

    public void deleteMediaContent(String sessionId, String mediaId) throws DocScanException {
        LOG.debug("Deleting media content '{}' in session '{}'", (Object)mediaId, (Object)sessionId);
        this.docScanService.deleteMediaContent(this.sdkId, this.keyPair, sessionId, mediaId);
    }

    public SupportedDocumentsResponse getSupportedDocuments() throws DocScanException {
        LOG.debug("Getting all supported documents");
        return this.docScanService.getSupportedDocuments(this.keyPair);
    }

    private KeyPair loadKeyPair(KeyPairSource kpSource) throws InitialisationException {
        try {
            LOG.debug("Loading key pair from '{}'", (Object)kpSource);
            return kpSource.getFromStream(new KeyStreamVisitor());
        }
        catch (IOException e) {
            throw new InitialisationException("Cannot load key pair", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class Builder {
        private static final DocScanService docScanService = DocScanService.newInstance();
        private String sdkId;
        private KeyPairSource keyPairSource;

        public Builder withClientSdkId(String sdkId) {
            this.sdkId = sdkId;
            return this;
        }

        public Builder withKeyPairSource(KeyPairSource kps) {
            this.keyPairSource = kps;
            return this;
        }

        public DocScanClient build() {
            Validation.notNullOrEmpty(this.sdkId, "SDK ID");
            Validation.notNull(this.keyPairSource, "Application key Pair");
            return new DocScanClient(this.sdkId, this.keyPairSource, docScanService);
        }
    }
}

