/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.yoti.api.client.Media;
import com.yoti.api.client.docs.DocScanException;
import com.yoti.api.client.docs.session.create.CreateSessionResult;
import com.yoti.api.client.docs.session.create.SessionSpec;
import com.yoti.api.client.docs.session.retrieve.GetSessionResult;
import com.yoti.api.client.docs.support.SupportedDocumentsResponse;
import com.yoti.api.client.spi.remote.MediaValue;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestBuilderFactory;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import com.yoti.api.client.spi.remote.call.factory.UnsignedPathFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DocScanService {
    private static final Logger LOG = LoggerFactory.getLogger(DocScanService.class);
    private static final int HTTP_STATUS_NO_CONTENT = 204;
    private final UnsignedPathFactory unsignedPathFactory;
    private final ObjectMapper objectMapper;
    private final SignedRequestBuilderFactory signedRequestBuilderFactory;
    private final String apiUrl;

    private DocScanService(UnsignedPathFactory pathFactory, ObjectMapper objectMapper, SignedRequestBuilderFactory signedRequestBuilderFactory) {
        this.unsignedPathFactory = pathFactory;
        this.objectMapper = objectMapper;
        this.signedRequestBuilderFactory = signedRequestBuilderFactory;
        this.apiUrl = System.getProperty("yoti.docs.url", "https://api.yoti.com/idverify/v1");
    }

    public static DocScanService newInstance() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return new DocScanService(new UnsignedPathFactory(), objectMapper, new SignedRequestBuilderFactory());
    }

    public CreateSessionResult createSession(String sdkId, KeyPair keyPair, SessionSpec sessionSpec) throws DocScanException {
        Validation.notNullOrEmpty(sdkId, "SDK ID");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNull(sessionSpec, "sessionSpec");
        String path = this.unsignedPathFactory.createNewYotiDocsSessionPath(sdkId);
        LOG.info("Creating session at '{}'", (Object)path);
        try {
            byte[] payload = this.objectMapper.writeValueAsBytes((Object)sessionSpec);
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("POST").withPayload(payload).withHeader("Content-Type", "application/json").build();
            return signedRequest.execute(CreateSessionResult.class);
        }
        catch (GeneralSecurityException ex) {
            throw new DocScanException("Error signing the request: " + ex.getMessage(), ex);
        }
        catch (ResourceException ex) {
            throw new DocScanException("Error posting the request: " + ex.getMessage(), ex);
        }
        catch (IOException | URISyntaxException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new DocScanException("Error creating the session: " + ex.getMessage(), ex);
        }
    }

    public GetSessionResult retrieveSession(String sdkId, KeyPair keyPair, String sessionId) throws DocScanException {
        Validation.notNullOrEmpty(sdkId, "SDK ID");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNullOrEmpty(sessionId, "sessionId");
        String path = this.unsignedPathFactory.createYotiDocsSessionPath(sdkId, sessionId);
        LOG.info("Fetching session from '{}'", (Object)path);
        try {
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("GET").build();
            return signedRequest.execute(GetSessionResult.class);
        }
        catch (GeneralSecurityException ex) {
            throw new DocScanException("Error signing the request: " + ex.getMessage(), ex);
        }
        catch (ResourceException ex) {
            throw new DocScanException("Error executing the GET: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new DocScanException("Error retrieving the session: " + ex.getMessage(), ex);
        }
    }

    public void deleteSession(String sdkId, KeyPair keyPair, String sessionId) throws DocScanException {
        Validation.notNullOrEmpty(sdkId, "SDK ID");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNullOrEmpty(sessionId, "sessionId");
        String path = this.unsignedPathFactory.createYotiDocsSessionPath(sdkId, sessionId);
        LOG.info("Deleting session from '{}'", (Object)path);
        try {
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("DELETE").build();
            signedRequest.execute();
        }
        catch (GeneralSecurityException ex) {
            throw new DocScanException("Error signing the request: " + ex.getMessage(), ex);
        }
        catch (ResourceException ex) {
            throw new DocScanException("Error executing the DELETE: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new DocScanException("Error deleting the session: " + ex.getMessage(), ex);
        }
    }

    public Media getMediaContent(String sdkId, KeyPair keyPair, String sessionId, String mediaId) throws DocScanException {
        Validation.notNullOrEmpty(sdkId, "SDK ID");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNullOrEmpty(sessionId, "sessionId");
        Validation.notNullOrEmpty(mediaId, "mediaId");
        String path = this.unsignedPathFactory.createMediaContentPath(sdkId, sessionId, mediaId);
        LOG.info("Fetching media from '{}'", (Object)path);
        try {
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("GET").build();
            SignedRequestResponse response = signedRequest.execute();
            if (response.getResponseCode() == 204) {
                return null;
            }
            return new MediaValue(this.findContentType(response), response.getResponseBody());
        }
        catch (GeneralSecurityException ex) {
            throw new DocScanException("Error signing the request: " + ex.getMessage(), ex);
        }
        catch (ResourceException ex) {
            throw new DocScanException("Error executing the GET: " + ex.getMessage(), ex);
        }
        catch (IOException | URISyntaxException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
    }

    public void deleteMediaContent(String sdkId, KeyPair keyPair, String sessionId, String mediaId) throws DocScanException {
        Validation.notNullOrEmpty(sdkId, "SDK ID");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNullOrEmpty(sessionId, "sessionId");
        Validation.notNullOrEmpty(mediaId, "mediaId");
        String path = this.unsignedPathFactory.createMediaContentPath(sdkId, sessionId, mediaId);
        LOG.info("Deleting media at '{}'", (Object)path);
        try {
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("DELETE").build();
            signedRequest.execute();
        }
        catch (GeneralSecurityException ex) {
            throw new DocScanException("Error signing the request: " + ex.getMessage(), ex);
        }
        catch (ResourceException ex) {
            throw new DocScanException("Error executing the DELETE: " + ex.getMessage(), ex);
        }
        catch (IOException | URISyntaxException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
    }

    public SupportedDocumentsResponse getSupportedDocuments(KeyPair keyPair) throws DocScanException {
        Validation.notNull(keyPair, "Application key Pair");
        String path = this.unsignedPathFactory.createGetSupportedDocumentsPath();
        try {
            SignedRequest signedRequest = this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("GET").build();
            return signedRequest.execute(SupportedDocumentsResponse.class);
        }
        catch (ResourceException | GeneralSecurityException ex) {
            throw new DocScanException("Error executing the GET: " + ex.getMessage(), ex);
        }
        catch (IOException | URISyntaxException ex) {
            throw new DocScanException("Error building the request: " + ex.getMessage(), ex);
        }
    }

    private String findContentType(SignedRequestResponse response) {
        List<String> contentTypeValues = null;
        for (Map.Entry<String, List<String>> entry : response.getResponseHeaders().entrySet()) {
            if (entry.getKey() == null || !entry.getKey().toLowerCase(Locale.ENGLISH).equals("Content-Type".toLowerCase(Locale.ENGLISH))) continue;
            contentTypeValues = entry.getValue();
            break;
        }
        return contentTypeValues == null || contentTypeValues.isEmpty() ? "" : (String)contentTypeValues.get(0);
    }
}

