/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class NotificationConfig {
    @JsonProperty(value="auth_token")
    private final String authToken;
    @JsonProperty(value="auth_type")
    private final String authType;
    @JsonProperty(value="endpoint")
    private final String endpoint;
    @JsonProperty(value="topics")
    private final List<String> topics;

    NotificationConfig(String authToken, String authType, String endpoint, List<String> topics) {
        this.authToken = authToken;
        this.authType = authType;
        this.endpoint = endpoint;
        this.topics = topics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public static class Builder {
        private final List<String> topics = new ArrayList<String>();
        private String authToken;
        private String authType;
        private String endpoint;

        private Builder() {
        }

        public Builder withAuthTypeBasic() {
            this.authType = "BASIC";
            return this;
        }

        public Builder withAuthTypeBearer() {
            this.authType = "BEARER";
            return this;
        }

        public Builder withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder forResourceUpdate() {
            return this.withTopic("RESOURCE_UPDATE");
        }

        public Builder forTaskCompletion() {
            return this.withTopic("TASK_COMPLETION");
        }

        public Builder forCheckCompletion() {
            return this.withTopic("CHECK_COMPLETION");
        }

        public Builder forSessionCompletion() {
            return this.withTopic("SESSION_COMPLETION");
        }

        public Builder withTopic(String topicName) {
            this.topics.add(topicName);
            return this;
        }

        public NotificationConfig build() {
            return new NotificationConfig(this.authToken, this.authType, this.endpoint, this.topics);
        }
    }
}

