/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SdkConfig {
    @JsonProperty(value="allowed_capture_methods")
    private final String allowedCaptureMethods;
    @JsonProperty(value="primary_colour")
    private final String primaryColour;
    @JsonProperty(value="secondary_colour")
    private final String secondaryColour;
    @JsonProperty(value="font_colour")
    private final String fontColour;
    @JsonProperty(value="locale")
    private final String locale;
    @JsonProperty(value="preset_issuing_country")
    private final String presetIssuingCountry;
    @JsonProperty(value="success_url")
    private final String successUrl;
    @JsonProperty(value="error_url")
    private final String errorUrl;
    @JsonProperty(value="privacy_policy_url")
    private final String privacyPolicyUrl;

    SdkConfig(String allowedCaptureMethods, String primaryColour, String secondaryColour, String fontColour, String locale, String presetIssuingCountry, String successUrl, String errorUrl, String privacyPolicyUrl) {
        this.allowedCaptureMethods = allowedCaptureMethods;
        this.primaryColour = primaryColour;
        this.secondaryColour = secondaryColour;
        this.fontColour = fontColour;
        this.locale = locale;
        this.presetIssuingCountry = presetIssuingCountry;
        this.successUrl = successUrl;
        this.errorUrl = errorUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAllowedCaptureMethods() {
        return this.allowedCaptureMethods;
    }

    public String getPrimaryColour() {
        return this.primaryColour;
    }

    public String getSecondaryColour() {
        return this.secondaryColour;
    }

    public String getFontColour() {
        return this.fontColour;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getPresetIssuingCountry() {
        return this.presetIssuingCountry;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    public static class Builder {
        private String allowedCaptureMethods;
        private String primaryColour;
        private String secondaryColour;
        private String fontColour;
        private String locale;
        private String presetIssuingCountry;
        private String successUrl;
        private String errorUrl;
        private String privacyPolicyUrl;

        private Builder() {
        }

        public Builder withAllowsCamera() {
            return this.withAllowedCaptureMethods("CAMERA");
        }

        public Builder withAllowsCameraAndUpload() {
            return this.withAllowedCaptureMethods("CAMERA_AND_UPLOAD");
        }

        public Builder withAllowedCaptureMethods(String allowedCaptureMethods) {
            this.allowedCaptureMethods = allowedCaptureMethods;
            return this;
        }

        public Builder withPrimaryColour(String primaryColour) {
            this.primaryColour = primaryColour;
            return this;
        }

        public Builder withSecondaryColour(String secondaryColour) {
            this.secondaryColour = secondaryColour;
            return this;
        }

        public Builder withFontColour(String fontColour) {
            this.fontColour = fontColour;
            return this;
        }

        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder withPresetIssuingCountry(String presetIssuingCountry) {
            this.presetIssuingCountry = presetIssuingCountry;
            return this;
        }

        public Builder withSuccessUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        public Builder withErrorUrl(String errorUrl) {
            this.errorUrl = errorUrl;
            return this;
        }

        public Builder withPrivacyPolicyUrl(String privacyPolicyUrl) {
            this.privacyPolicyUrl = privacyPolicyUrl;
            return this;
        }

        public SdkConfig build() {
            return new SdkConfig(this.allowedCaptureMethods, this.primaryColour, this.secondaryColour, this.fontColour, this.locale, this.presetIssuingCountry, this.successUrl, this.errorUrl, this.privacyPolicyUrl);
        }
    }
}

