/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.docs.session.create.NotificationConfig;
import com.yoti.api.client.docs.session.create.SdkConfig;
import com.yoti.api.client.docs.session.create.check.RequestedCheck;
import com.yoti.api.client.docs.session.create.filters.RequiredDocument;
import com.yoti.api.client.docs.session.create.task.RequestedTask;
import java.util.ArrayList;
import java.util.List;

public class SessionSpec {
    @JsonProperty(value="client_session_token_ttl")
    private final Integer clientSessionTokenTtl;
    @JsonProperty(value="resources_ttl")
    private final Integer resourcesTtl;
    @JsonProperty(value="user_tracking_id")
    private final String userTrackingId;
    @JsonProperty(value="notifications")
    private final NotificationConfig notifications;
    @JsonProperty(value="requested_checks")
    private final List<RequestedCheck<?>> requestedChecks;
    @JsonProperty(value="requested_tasks")
    private final List<RequestedTask<?>> requestedTasks;
    @JsonProperty(value="sdk_config")
    private final SdkConfig sdkConfig;
    @JsonProperty(value="required_documents")
    private final List<RequiredDocument> requiredDocuments;
    @JsonProperty(value="block_biometric_consent")
    private final Boolean blockBiometricConsent;

    SessionSpec(Integer clientSessionTokenTtl, Integer resourcesTtl, String userTrackingId, NotificationConfig notifications, List<RequestedCheck<?>> requestedChecks, List<RequestedTask<?>> requestedTasks, SdkConfig sdkConfig, List<RequiredDocument> requiredDocuments, Boolean blockBiometricConsent) {
        this.clientSessionTokenTtl = clientSessionTokenTtl;
        this.resourcesTtl = resourcesTtl;
        this.userTrackingId = userTrackingId;
        this.notifications = notifications;
        this.requestedChecks = requestedChecks;
        this.requestedTasks = requestedTasks;
        this.sdkConfig = sdkConfig;
        this.requiredDocuments = requiredDocuments;
        this.blockBiometricConsent = blockBiometricConsent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getClientSessionTokenTtl() {
        return this.clientSessionTokenTtl;
    }

    public Integer getResourcesTtl() {
        return this.resourcesTtl;
    }

    public String getUserTrackingId() {
        return this.userTrackingId;
    }

    public NotificationConfig getNotifications() {
        return this.notifications;
    }

    public List<RequestedCheck<?>> getRequestedChecks() {
        return this.requestedChecks;
    }

    public List<RequestedTask<?>> getRequestedTasks() {
        return this.requestedTasks;
    }

    public SdkConfig getSdkConfig() {
        return this.sdkConfig;
    }

    public List<RequiredDocument> getRequiredDocuments() {
        return this.requiredDocuments;
    }

    public Boolean getBlockBiometricConsent() {
        return this.blockBiometricConsent;
    }

    public static class Builder {
        private final List<RequestedCheck<?>> requestedChecks = new ArrayList();
        private final List<RequestedTask<?>> requestedTasks = new ArrayList();
        private final List<RequiredDocument> requiredDocuments = new ArrayList<RequiredDocument>();
        private Integer clientSessionTokenTtl;
        private Integer resourcesTtl;
        private String userTrackingId;
        private NotificationConfig notifications;
        private SdkConfig sdkConfig;
        private Boolean blockBiometricConsent;

        private Builder() {
        }

        public Builder withClientSessionTokenTtl(Integer clientSessionTokenTtl) {
            this.clientSessionTokenTtl = clientSessionTokenTtl;
            return this;
        }

        public Builder withResourcesTtl(Integer resourcesTtl) {
            this.resourcesTtl = resourcesTtl;
            return this;
        }

        public Builder withUserTrackingId(String userTrackingId) {
            this.userTrackingId = userTrackingId;
            return this;
        }

        public Builder withNotifications(NotificationConfig notifications) {
            this.notifications = notifications;
            return this;
        }

        public Builder withRequestedCheck(RequestedCheck<?> requestedCheck) {
            this.requestedChecks.add(requestedCheck);
            return this;
        }

        public Builder withRequestedTask(RequestedTask<?> requestedTask) {
            this.requestedTasks.add(requestedTask);
            return this;
        }

        public Builder withSdkConfig(SdkConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public Builder withRequiredDocument(RequiredDocument requiredDocument) {
            this.requiredDocuments.add(requiredDocument);
            return this;
        }

        public Builder withBlockBiometricConsent(boolean blockBiometricConsent) {
            this.blockBiometricConsent = blockBiometricConsent;
            return this;
        }

        public SessionSpec build() {
            return new SessionSpec(this.clientSessionTokenTtl, this.resourcesTtl, this.userTrackingId, this.notifications, this.requestedChecks, this.requestedTasks, this.sdkConfig, this.requiredDocuments, this.blockBiometricConsent);
        }
    }
}

