/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create.check;

import com.yoti.api.client.docs.session.create.check.RequestedCheck;
import com.yoti.api.client.docs.session.create.check.RequestedFaceMatchConfig;
import com.yoti.api.client.spi.remote.util.Validation;

public class RequestedFaceMatchCheck
extends RequestedCheck<RequestedFaceMatchConfig> {
    private final RequestedFaceMatchConfig config;

    RequestedFaceMatchCheck(RequestedFaceMatchConfig config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return "ID_DOCUMENT_FACE_MATCH";
    }

    @Override
    public RequestedFaceMatchConfig getConfig() {
        return this.config;
    }

    public static class Builder {
        private String manualCheck;

        public Builder withManualCheckAlways() {
            this.manualCheck = "ALWAYS";
            return this;
        }

        public Builder withManualCheckFallback() {
            this.manualCheck = "FALLBACK";
            return this;
        }

        public Builder withManualCheckNever() {
            this.manualCheck = "NEVER";
            return this;
        }

        public RequestedFaceMatchCheck build() {
            Validation.notNullOrEmpty(this.manualCheck, "manualCheck");
            RequestedFaceMatchConfig config = new RequestedFaceMatchConfig(this.manualCheck);
            return new RequestedFaceMatchCheck(config);
        }
    }
}

