/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create.check;

import com.yoti.api.client.docs.session.create.check.RequestedCheck;
import com.yoti.api.client.docs.session.create.check.RequestedLivenessConfig;
import com.yoti.api.client.spi.remote.util.Validation;

public class RequestedLivenessCheck
extends RequestedCheck<RequestedLivenessConfig> {
    private final RequestedLivenessConfig config;

    RequestedLivenessCheck(RequestedLivenessConfig config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return "LIVENESS";
    }

    @Override
    public RequestedLivenessConfig getConfig() {
        return this.config;
    }

    public static class Builder {
        private String livenessType;
        private int maxRetries = 1;

        public Builder forZoomLiveness() {
            return this.forLivenessType("ZOOM");
        }

        public Builder forLivenessType(String livenessType) {
            this.livenessType = livenessType;
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public RequestedLivenessCheck build() {
            Validation.notNullOrEmpty(this.livenessType, "livenessType");
            RequestedLivenessConfig config = new RequestedLivenessConfig(this.maxRetries, this.livenessType);
            return new RequestedLivenessCheck(config);
        }
    }
}

