/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.docs.session.create.filters.DocumentFilter;
import com.yoti.api.client.docs.session.create.filters.DocumentRestriction;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.ArrayList;
import java.util.List;

public class DocumentRestrictionsFilter
extends DocumentFilter {
    @JsonProperty(value="inclusion")
    private final String inclusion;
    @JsonProperty(value="documents")
    private final List<DocumentRestriction> documents;

    DocumentRestrictionsFilter(String inclusion, List<DocumentRestriction> documents) {
        super("DOCUMENT_RESTRICTIONS");
        this.inclusion = inclusion;
        this.documents = documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInclusion() {
        return this.inclusion;
    }

    public List<DocumentRestriction> getDocuments() {
        return this.documents;
    }

    public static class Builder {
        private String inclusion;
        private final List<DocumentRestriction> documents = new ArrayList<DocumentRestriction>();

        private Builder() {
        }

        public Builder forWhitelist() {
            this.inclusion = "WHITELIST";
            return this;
        }

        public Builder forBlacklist() {
            this.inclusion = "BLACKLIST";
            return this;
        }

        public Builder withDocumentRestriction(List<String> countryCodes, List<String> documentTypes) {
            this.documents.add(new DocumentRestriction(countryCodes, documentTypes));
            return this;
        }

        public Builder withDocumentRestriction(DocumentRestriction documentRestriction) {
            this.documents.add(documentRestriction);
            return this;
        }

        public DocumentRestrictionsFilter build() {
            Validation.notNullOrEmpty(this.inclusion, "inclusion");
            return new DocumentRestrictionsFilter(this.inclusion, this.documents);
        }
    }
}

