/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.docs.session.create.filters.CountryRestriction;
import com.yoti.api.client.docs.session.create.filters.DocumentFilter;
import com.yoti.api.client.docs.session.create.filters.TypeRestriction;
import java.util.List;

public class OrthogonalRestrictionsFilter
extends DocumentFilter {
    @JsonProperty(value="country_restriction")
    private final CountryRestriction countryRestriction;
    @JsonProperty(value="type_restriction")
    private final TypeRestriction typeRestriction;

    OrthogonalRestrictionsFilter(CountryRestriction countryRestriction, TypeRestriction typeRestriction) {
        super("ORTHOGONAL_RESTRICTIONS");
        this.countryRestriction = countryRestriction;
        this.typeRestriction = typeRestriction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CountryRestriction getCountryRestriction() {
        return this.countryRestriction;
    }

    public TypeRestriction getTypeRestriction() {
        return this.typeRestriction;
    }

    public static class Builder {
        private CountryRestriction countryRestriction;
        private TypeRestriction typeRestriction;

        private Builder() {
        }

        public Builder withWhitelistedCountries(List<String> countryCodes) {
            this.countryRestriction = new CountryRestriction("WHITELIST", countryCodes);
            return this;
        }

        public Builder withBlacklistedCountries(List<String> countryCodes) {
            this.countryRestriction = new CountryRestriction("BLACKLIST", countryCodes);
            return this;
        }

        public Builder withWhitelistedDocumentTypes(List<String> documentTypes) {
            this.typeRestriction = new TypeRestriction("WHITELIST", documentTypes);
            return this;
        }

        public Builder withBlacklistedDocumentTypes(List<String> documentTypes) {
            this.typeRestriction = new TypeRestriction("BLACKLIST", documentTypes);
            return this;
        }

        public OrthogonalRestrictionsFilter build() {
            return new OrthogonalRestrictionsFilter(this.countryRestriction, this.typeRestriction);
        }
    }
}

