/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.create.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.docs.session.create.filters.RequiredDocument;
import com.yoti.api.client.docs.session.create.objective.Objective;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.List;

public class RequiredSupplementaryDocument
extends RequiredDocument {
    @JsonProperty(value="objective")
    private final Objective objective;
    @JsonProperty(value="document_types")
    private final List<String> documentTypes;
    @JsonProperty(value="country_codes")
    private final List<String> countryCodes;

    RequiredSupplementaryDocument(Objective objective, List<String> documentTypes, List<String> countryCodes) {
        this.objective = objective;
        this.documentTypes = documentTypes;
        this.countryCodes = countryCodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return "SUPPLEMENTARY_DOCUMENT";
    }

    public Objective getObjective() {
        return this.objective;
    }

    public List<String> getDocumentTypes() {
        return this.documentTypes;
    }

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public static class Builder {
        private Objective objective;
        private List<String> documentTypes;
        private List<String> countryCodes;

        public Builder withObjective(Objective objective) {
            this.objective = objective;
            return this;
        }

        public Builder withDocumentTypes(List<String> documentTypes) {
            Validation.notNull(documentTypes, "documentTypes");
            this.documentTypes = documentTypes;
            return this;
        }

        public Builder withCountryCodes(List<String> countryCodes) {
            Validation.notNull(countryCodes, "countryCodes");
            this.countryCodes = countryCodes;
            return this;
        }

        public RequiredSupplementaryDocument build() {
            Validation.notNull(this.objective, "objective");
            return new RequiredSupplementaryDocument(this.objective, this.documentTypes, this.countryCodes);
        }
    }
}

