/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.docs.session.retrieve;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.docs.session.retrieve.AuthenticityCheckResponse;
import com.yoti.api.client.docs.session.retrieve.CheckResponse;
import com.yoti.api.client.docs.session.retrieve.FaceMatchCheckResponse;
import com.yoti.api.client.docs.session.retrieve.IdDocumentComparisonCheckResponse;
import com.yoti.api.client.docs.session.retrieve.LivenessCheckResponse;
import com.yoti.api.client.docs.session.retrieve.ResourceContainer;
import com.yoti.api.client.docs.session.retrieve.SupplementaryDocumentTextDataCheckResponse;
import com.yoti.api.client.docs.session.retrieve.TextDataCheckResponse;
import com.yoti.api.client.docs.session.retrieve.ThirdPartyIdentityCheckResponse;
import java.util.ArrayList;
import java.util.List;

public class GetSessionResult {
    @JsonProperty(value="client_session_token_ttl")
    private long clientSessionTokenTtl;
    @JsonProperty(value="session_id")
    private String sessionId;
    @JsonProperty(value="user_tracking_id")
    private String userTrackingId;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="client_session_token")
    private String clientSessionToken;
    @JsonProperty(value="biometric_consent")
    private String biometricConsent;
    @JsonProperty(value="checks")
    private List<? extends CheckResponse> checks;
    @JsonProperty(value="resources")
    private ResourceContainer resources;

    public String getSessionId() {
        return this.sessionId;
    }

    public long getClientSessionTokenTtl() {
        return this.clientSessionTokenTtl;
    }

    public String getState() {
        return this.state;
    }

    public String getClientSessionToken() {
        return this.clientSessionToken;
    }

    public String getBiometricConsentTimestamp() {
        return this.biometricConsent;
    }

    public List<? extends CheckResponse> getChecks() {
        return this.checks;
    }

    public ResourceContainer getResources() {
        return this.resources;
    }

    public String getUserTrackingId() {
        return this.userTrackingId;
    }

    public List<AuthenticityCheckResponse> getAuthenticityChecks() {
        return this.filterChecksByType(AuthenticityCheckResponse.class);
    }

    public List<FaceMatchCheckResponse> getFaceMatchChecks() {
        return this.filterChecksByType(FaceMatchCheckResponse.class);
    }

    public List<TextDataCheckResponse> getIdDocumentTextDataChecks() {
        return this.filterChecksByType(TextDataCheckResponse.class);
    }

    public List<SupplementaryDocumentTextDataCheckResponse> getSupplementaryDocumentTextDataChecks() {
        return this.filterChecksByType(SupplementaryDocumentTextDataCheckResponse.class);
    }

    public List<LivenessCheckResponse> getLivenessChecks() {
        return this.filterChecksByType(LivenessCheckResponse.class);
    }

    public List<IdDocumentComparisonCheckResponse> getIdDocumentComparisonChecks() {
        return this.filterChecksByType(IdDocumentComparisonCheckResponse.class);
    }

    public List<ThirdPartyIdentityCheckResponse> getThirdPartyIdentityChecks() {
        return this.filterChecksByType(ThirdPartyIdentityCheckResponse.class);
    }

    private <T extends CheckResponse> List<T> filterChecksByType(Class<T> clazz) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (CheckResponse checkResponse : this.checks) {
            if (!clazz.isInstance(checkResponse)) continue;
            filteredList.add(clazz.cast(checkResponse));
        }
        return filteredList;
    }
}

