/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.shareurl.extension.Extension;
import com.yoti.api.client.shareurl.policy.DynamicPolicy;
import java.util.ArrayList;
import java.util.List;

public class DynamicScenario {
    @JsonProperty(value="callback_endpoint")
    private final String callbackEndpoint;
    @JsonProperty(value="policy")
    private final DynamicPolicy dynamicPolicy;
    @JsonProperty(value="extensions")
    private final List<Extension<?>> extensions;

    DynamicScenario(String callbackEndpoint, DynamicPolicy dynamicPolicy, List<Extension<?>> extensions) {
        this.callbackEndpoint = callbackEndpoint;
        this.dynamicPolicy = dynamicPolicy;
        this.extensions = extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String callbackEndpoint() {
        return this.callbackEndpoint;
    }

    public DynamicPolicy policy() {
        return this.dynamicPolicy;
    }

    public List<Extension<?>> extensions() {
        return this.extensions;
    }

    public static class Builder {
        private String callbackEndpoint;
        private DynamicPolicy dynamicPolicy;
        private final List<Extension<?>> extensions = new ArrayList();

        public Builder withCallbackEndpoint(String callbackEndpoint) {
            this.callbackEndpoint = callbackEndpoint;
            return this;
        }

        public Builder withPolicy(DynamicPolicy dynamicPolicy) {
            this.dynamicPolicy = dynamicPolicy;
            return this;
        }

        public Builder withExtension(Extension<?> extension) {
            this.extensions.add(extension);
            return this;
        }

        public DynamicScenario build() {
            return new DynamicScenario(this.callbackEndpoint, this.dynamicPolicy, this.extensions);
        }
    }
}

