/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.constraint;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.shareurl.constraint.Constraint;
import com.yoti.api.client.shareurl.constraint.PreferredSources;
import com.yoti.api.client.shareurl.policy.WantedAnchor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SourceConstraint
implements Constraint {
    @JsonProperty(value="type")
    private static final String type = "SOURCE";
    @JsonProperty(value="preferred_sources")
    private final PreferredSources preferredSources;

    SourceConstraint(List<WantedAnchor> wantedAnchors, boolean softPreference) {
        this.preferredSources = new PreferredSources(wantedAnchors, softPreference);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return type;
    }

    public PreferredSources getPreferredSources() {
        return this.preferredSources;
    }

    public static class Builder {
        private final List<WantedAnchor> wantedAnchors = new ArrayList<WantedAnchor>();
        private boolean softPreference = false;

        private Builder() {
        }

        public Builder withWantedAnchor(WantedAnchor wantedAnchor) {
            this.wantedAnchors.add(wantedAnchor);
            return this;
        }

        public Builder withSoftPreference(boolean softPreference) {
            this.softPreference = softPreference;
            return this;
        }

        public SourceConstraint build() {
            return new SourceConstraint(Collections.unmodifiableList(this.wantedAnchors), this.softPreference);
        }
    }
}

