/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.policy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.shareurl.constraint.Constraint;
import com.yoti.api.client.shareurl.policy.WantedAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicPolicy {
    @JsonProperty(value="wanted")
    private final Collection<WantedAttribute> wantedAttributes;
    @JsonProperty(value="wanted_auth_types")
    private final Set<Integer> wantedAuthTypes;
    @JsonProperty(value="wanted_remember_me")
    private final boolean wantedRememberMe;
    @JsonProperty(value="wanted_remember_me_optional")
    private final boolean wantedRememberMeOptional;

    DynamicPolicy(Collection<WantedAttribute> wantedAttributes, Set<Integer> wantedAuthTypes, boolean wantedRememberMe, boolean wantedRememberMeOptional) {
        this.wantedAttributes = wantedAttributes;
        this.wantedAuthTypes = wantedAuthTypes;
        this.wantedRememberMe = wantedRememberMe;
        this.wantedRememberMeOptional = wantedRememberMeOptional;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<WantedAttribute> getWantedAttributes() {
        return this.wantedAttributes;
    }

    public Set<Integer> getWantedAuthTypes() {
        return this.wantedAuthTypes;
    }

    public boolean isWantedRememberMe() {
        return this.wantedRememberMe;
    }

    public boolean isWantedRememberMeOptional() {
        return this.wantedRememberMeOptional;
    }

    public static class Builder {
        private static final int SELFIE_AUTH_TYPE = 1;
        private static final int PIN_AUTH_TYPE = 2;
        private final Map<String, WantedAttribute> wantedAttributes = new HashMap<String, WantedAttribute>();
        private final Set<Integer> wantedAuthTypes = new HashSet<Integer>();
        private boolean wantedRememberMe;
        private boolean wantedRememberMeOptional;

        public Builder withWantedAttribute(WantedAttribute wantedAttribute) {
            String key;
            String string = key = wantedAttribute.getDerivation() != null ? wantedAttribute.getDerivation() : wantedAttribute.getName();
            if (wantedAttribute.getConstraints().size() > 0) {
                key = key + "-" + wantedAttribute.getConstraints().hashCode();
            }
            this.wantedAttributes.put(key, wantedAttribute);
            return this;
        }

        public Builder withWantedAttribute(boolean optional, String name, List<Constraint> constraints) {
            WantedAttribute wantedAttribute = WantedAttribute.builder().withName(name).withOptional(optional).withConstraints(constraints).build();
            return this.withWantedAttribute(wantedAttribute);
        }

        public Builder withWantedAttribute(boolean optional, String name) {
            return this.withWantedAttribute(optional, name, Collections.emptyList());
        }

        public Builder withFamilyName() {
            return this.withFamilyName(false);
        }

        public Builder withFamilyName(boolean optional) {
            return this.withWantedAttribute(optional, "family_name");
        }

        public Builder withGivenNames() {
            return this.withGivenNames(false);
        }

        public Builder withGivenNames(boolean optional) {
            return this.withWantedAttribute(optional, "given_names");
        }

        public Builder withFullName() {
            return this.withFullName(false);
        }

        public Builder withFullName(boolean optional) {
            return this.withWantedAttribute(optional, "full_name");
        }

        public Builder withDateOfBirth() {
            return this.withDateOfBirth(false);
        }

        public Builder withDateOfBirth(boolean optional) {
            return this.withWantedAttribute(optional, "date_of_birth");
        }

        public Builder withAgeOver(int age) {
            return this.withAgeOver(false, age);
        }

        public Builder withAgeOver(boolean optional, int age) {
            return this.withAgeDerivedAttribute(optional, "age_over:" + age);
        }

        public Builder withAgeUnder(int age) {
            return this.withAgeUnder(false, age);
        }

        public Builder withAgeUnder(boolean optional, int age) {
            return this.withAgeDerivedAttribute(optional, "age_under:" + age);
        }

        private Builder withAgeDerivedAttribute(boolean optional, String derivation) {
            WantedAttribute wantedAttribute = WantedAttribute.builder().withName("date_of_birth").withDerivation(derivation).withOptional(optional).build();
            return this.withWantedAttribute(wantedAttribute);
        }

        public Builder withGender() {
            return this.withGender(false);
        }

        public Builder withGender(boolean optional) {
            return this.withWantedAttribute(optional, "gender");
        }

        public Builder withPostalAddress() {
            return this.withPostalAddress(false);
        }

        public Builder withPostalAddress(boolean optional) {
            return this.withWantedAttribute(optional, "postal_address");
        }

        public Builder withStructuredPostalAddress() {
            return this.withStructuredPostalAddress(false);
        }

        public Builder withStructuredPostalAddress(boolean optional) {
            return this.withWantedAttribute(optional, "structured_postal_address");
        }

        public Builder withNationality() {
            return this.withNationality(false);
        }

        public Builder withNationality(boolean optional) {
            return this.withWantedAttribute(optional, "nationality");
        }

        public Builder withPhoneNumber() {
            return this.withPhoneNumber(false);
        }

        public Builder withPhoneNumber(boolean optional) {
            return this.withWantedAttribute(optional, "phone_number");
        }

        public Builder withSelfie() {
            return this.withSelfie(false);
        }

        public Builder withSelfie(boolean optional) {
            return this.withWantedAttribute(optional, "selfie");
        }

        public Builder withEmail() {
            return this.withEmail(false);
        }

        public Builder withEmail(boolean optional) {
            return this.withWantedAttribute(optional, "email_address");
        }

        public Builder withSelfieAuthentication(boolean enabled) {
            return this.withWantedAuthType(1, enabled);
        }

        public Builder withPinAuthentication(boolean enabled) {
            return this.withWantedAuthType(2, enabled);
        }

        public Builder withWantedAuthType(int wantedAuthType) {
            this.wantedAuthTypes.add(wantedAuthType);
            return this;
        }

        public Builder withWantedAuthType(int wantedAuthType, boolean enabled) {
            if (enabled) {
                return this.withWantedAuthType(wantedAuthType);
            }
            this.wantedAuthTypes.remove(wantedAuthType);
            return this;
        }

        public Builder withWantedRememberMe(boolean wantedRememberMe) {
            this.wantedRememberMe = wantedRememberMe;
            return this;
        }

        public Builder withWantedRememberMeOptional(boolean wantedRememberMeOptional) {
            this.wantedRememberMeOptional = wantedRememberMeOptional;
            return this;
        }

        public DynamicPolicy build() {
            return new DynamicPolicy(this.wantedAttributes.values(), this.wantedAuthTypes, this.wantedRememberMe, this.wantedRememberMeOptional);
        }
    }
}

