/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.policy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.spi.remote.util.Validation;

public class WantedAnchor {
    @JsonProperty(value="name")
    private final String value;
    @JsonProperty(value="sub_type")
    private final String subType;

    WantedAnchor(String value, String subType) {
        Validation.notNullOrEmpty(value, "value");
        Validation.notNull(subType, "subType");
        this.value = value;
        this.subType = subType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getValue() {
        return this.value;
    }

    public String getSubType() {
        return this.subType;
    }

    public static class Builder {
        private String value;
        private String subType;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withSubType(String subType) {
            this.subType = subType;
            return this;
        }

        public WantedAnchor build() {
            return new WantedAnchor(this.value, this.subType);
        }
    }
}

