/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.policy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yoti.api.client.shareurl.constraint.Constraint;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WantedAttribute {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="derivation")
    private final String derivation;
    @JsonProperty(value="optional")
    private final boolean optional;
    @JsonProperty(value="accept_self_asserted")
    private final Boolean acceptSelfAsserted;
    @JsonProperty(value="constraints")
    private final List<Constraint> constraints;

    WantedAttribute(String name, String derivation, boolean optional, Boolean acceptSelfAsserted, List<Constraint> constraints) {
        Validation.notNullOrEmpty(name, "name");
        this.name = name;
        this.derivation = derivation;
        this.optional = optional;
        this.acceptSelfAsserted = acceptSelfAsserted;
        this.constraints = constraints == null ? Collections.emptyList() : constraints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDerivation() {
        return this.derivation;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Boolean getAcceptSelfAsserted() {
        return this.acceptSelfAsserted;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public static class Builder {
        private String name;
        private String derivation;
        private boolean optional;
        private Boolean acceptSelfAsserted;
        private List<Constraint> constraints = new ArrayList<Constraint>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDerivation(String derivation) {
            this.derivation = derivation;
            return this;
        }

        public Builder withOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder withAcceptSelfAsserted(boolean acceptSelfAsserted) {
            this.acceptSelfAsserted = acceptSelfAsserted;
            return this;
        }

        public Builder withConstraints(List<Constraint> constraints) {
            this.constraints = Collections.unmodifiableList(constraints);
            return this;
        }

        public Builder withConstraint(Constraint constraint) {
            this.constraints.add(constraint);
            return this;
        }

        public WantedAttribute build() {
            return new WantedAttribute(this.name, this.derivation, this.optional, this.acceptSelfAsserted, this.constraints);
        }
    }
}

