/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.ActivityDetails;
import com.yoti.api.client.ApplicationProfile;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.ExtraData;
import com.yoti.api.client.ExtraDataException;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.spi.remote.AttributeListReader;
import com.yoti.api.client.spi.remote.ExtraDataReader;
import com.yoti.api.client.spi.remote.call.Receipt;
import com.yoti.api.client.spi.remote.util.DecryptionHelper;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDetailsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityDetailsFactory.class);
    private final AttributeListReader attributeListReader;
    private final ExtraDataReader extraDataReader;

    private ActivityDetailsFactory(AttributeListReader attributeListReader, ExtraDataReader extraDataReader) {
        this.attributeListReader = Validation.notNull(attributeListReader, "profileReader");
        this.extraDataReader = Validation.notNull(extraDataReader, "extraDataReader");
    }

    public static ActivityDetailsFactory newInstance() {
        return new ActivityDetailsFactory(AttributeListReader.newInstance(), ExtraDataReader.newInstance());
    }

    public ActivityDetails create(Receipt receipt, PrivateKey privateKey) throws ProfileException {
        byte[] decryptedKey = DecryptionHelper.decryptAsymmetric(receipt.getWrappedReceiptKey(), privateKey);
        SecretKeySpec secretKey = new SecretKeySpec(decryptedKey, "AES/CBC/PKCS7Padding");
        List<Attribute<?>> userProfileAttr = this.attributeListReader.read(receipt.getOtherPartyProfile(), secretKey);
        List<Attribute<?>> applicationProfileAttr = this.attributeListReader.read(receipt.getProfile(), secretKey);
        HumanProfile userProfile = new HumanProfile(userProfileAttr);
        ApplicationProfile applicationProfile = new ApplicationProfile(applicationProfileAttr);
        ExtraData extraData = this.parseExtraData(receipt.getExtraData(), secretKey);
        String rememberMeId = this.parseRememberMeId(receipt.getRememberMeId());
        String parentRememberMeId = this.parseRememberMeId(receipt.getParentRememberMeId());
        Date timestamp = this.parseTimestamp(receipt.getTimestamp());
        return new ActivityDetails(rememberMeId, parentRememberMeId, userProfile, applicationProfile, extraData, timestamp, receipt.getReceiptId());
    }

    private ExtraData parseExtraData(byte[] extraDataBytes, Key secretKey) throws ProfileException {
        ExtraData extraData;
        try {
            extraData = this.extraDataReader.read(extraDataBytes, secretKey);
        }
        catch (ExtraDataException e) {
            LOG.error("Failed to parse extra data from receipt");
            extraData = new ExtraData();
        }
        return extraData;
    }

    private String parseRememberMeId(byte[] rmi) throws ProfileException {
        try {
            return rmi == null ? null : new String(Base64.getEncoder().encode(rmi), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProfileException("Cannot parse user ID", e);
        }
    }

    private Date parseTimestamp(String timestamp) throws ProfileException {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return dateFormat.parse(timestamp);
        }
        catch (ParseException e) {
            throw new ProfileException("Cannot parse timestamp", e);
        }
    }
}

