/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.Anchor;
import com.yoti.api.client.DateTime;
import com.yoti.api.client.SignedTimestamp;
import com.yoti.api.client.spi.remote.proto.AttrProto;
import com.yoti.api.client.spi.remote.proto.SignedTimestampProto;
import com.yoti.api.client.spi.remote.util.AnchorType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnchorConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AnchorConverter.class);

    AnchorConverter() {
    }

    Anchor convert(AttrProto.Anchor anchorProto) throws CertificateException, IOException {
        List<X509Certificate> certificates = this.convertCertificates(anchorProto);
        AnchorTypeAndValue anchorTypeAndValue = this.determineAnchorType(certificates);
        String anchorType = anchorTypeAndValue.anchorType.name();
        String value = anchorTypeAndValue.value;
        SignedTimestamp signedTimestamp = this.convertSignedTimestamp(anchorProto.getSignedTimeStamp());
        return new Anchor(anchorType, anchorProto.getSubType(), value, certificates, signedTimestamp);
    }

    private List<X509Certificate> convertCertificates(AttrProto.Anchor anchorProto) throws CertificateException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        for (ByteString byteString : anchorProto.getOriginServerCertsList()) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteString.toByteArray());
            certificates.add((X509Certificate)factory.generateCertificate(byteArrayInputStream));
        }
        return certificates;
    }

    private AnchorTypeAndValue determineAnchorType(List<X509Certificate> certificates) throws IOException {
        for (X509Certificate certificate : certificates) {
            for (AnchorType anchorType : AnchorType.values()) {
                String type = this.findExtension(certificate, anchorType);
                if (type == null) continue;
                return new AnchorTypeAndValue(anchorType, type);
            }
        }
        return new AnchorTypeAndValue(AnchorType.UNKNOWN, "");
    }

    private String findExtension(X509Certificate certificate, AnchorType anchorType) throws IOException {
        DEROctetString derOctetString;
        ASN1Primitive asn1Primitive1;
        DLSequence dlSequence;
        Enumeration seqEnum;
        ASN1Primitive derObject;
        byte[] extension = certificate.getExtensionValue(anchorType.extensionOid);
        if (extension != null && (derObject = ASN1Primitive.fromByteArray((byte[])extension)) instanceof DEROctetString && (seqEnum = (dlSequence = (DLSequence)(asn1Primitive1 = ASN1Primitive.fromByteArray((byte[])(derOctetString = (DEROctetString)derObject).getOctets()))).getObjects()).hasMoreElements()) {
            ASN1TaggedObject seqObj = (ASN1TaggedObject)seqEnum.nextElement();
            ASN1OctetString string = DEROctetString.getInstance((ASN1TaggedObject)seqObj, (boolean)false);
            String type = new String(string.getOctets(), "UTF-8");
            LOG.debug("Anchor certificate type: '{}' for extension: {}", (Object)type, (Object)anchorType.extensionOid);
            return type;
        }
        return null;
    }

    private SignedTimestamp convertSignedTimestamp(ByteString timestampByteString) throws InvalidProtocolBufferException {
        SignedTimestampProto.SignedTimestamp timestampProto = SignedTimestampProto.SignedTimestamp.parseFrom(timestampByteString);
        return new SignedTimestamp(timestampProto.getVersion(), DateTime.from(timestampProto.getTimestamp()));
    }

    private static class AnchorTypeAndValue {
        private final AnchorType anchorType;
        private final String value;

        private AnchorTypeAndValue(AnchorType anchorType, String value) {
            this.anchorType = anchorType;
            this.value = value;
        }
    }
}

