/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.spi.remote.AddressTransformer;
import com.yoti.api.client.spi.remote.AttributeConverter;
import com.yoti.api.client.spi.remote.proto.AttrProto;
import com.yoti.api.client.spi.remote.proto.AttributeListProto;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeListConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeListConverter.class);
    private final AttributeConverter attributeConverter;
    private final AddressTransformer addressTransformer;

    private AttributeListConverter(AttributeConverter attributeConverter, AddressTransformer addressTransformer) {
        this.attributeConverter = attributeConverter;
        this.addressTransformer = addressTransformer;
    }

    static AttributeListConverter newInstance() {
        return new AttributeListConverter(AttributeConverter.newInstance(), AddressTransformer.newInstance());
    }

    List<Attribute<?>> parseAttributeList(byte[] attributeListBytes) throws ProfileException {
        if (attributeListBytes == null || attributeListBytes.length == 0) {
            return Collections.emptyList();
        }
        AttributeListProto.AttributeList attributeList = this.parseProto(attributeListBytes);
        List<Attribute<?>> attributes = this.parseAttributes(attributeList);
        LOG.debug("{} out of {} attribute(s) parsed successfully ", (Object)attributes.size(), (Object)attributeList.getAttributesCount());
        this.ensurePostalAddress(attributes);
        return attributes;
    }

    private AttributeListProto.AttributeList parseProto(byte[] attributeListBytes) throws ProfileException {
        try {
            return AttributeListProto.AttributeList.parseFrom(attributeListBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProfileException("Cannot parse profile data", e);
        }
    }

    private List<Attribute<?>> parseAttributes(AttributeListProto.AttributeList message) {
        ArrayList parsedAttributes = new ArrayList();
        for (AttrProto.Attribute attribute : message.getAttributesList()) {
            try {
                parsedAttributes.add(this.attributeConverter.convertAttribute(attribute));
            }
            catch (IOException | ParseException e) {
                LOG.warn("Failed to parse attribute '{}' due to '{}'", (Object)attribute.getName(), (Object)e.getMessage());
            }
        }
        return parsedAttributes;
    }

    private void ensurePostalAddress(List<Attribute<?>> attributes) {
        Attribute<String> transformedAddress;
        Attribute<?> structuredPostalAddress;
        if (this.findAttribute("postal_address", attributes) == null && (structuredPostalAddress = this.findAttribute("structured_postal_address", attributes)) != null && (transformedAddress = this.addressTransformer.transform(structuredPostalAddress)) != null) {
            LOG.debug("Substituting '{}' in place of missing '{}'", (Object)"structured_postal_address", (Object)"postal_address");
            attributes.add(transformedAddress);
        }
    }

    private Attribute<?> findAttribute(String name, List<Attribute<?>> attributes) {
        for (Attribute<?> attribute : attributes) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }
}

