/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

class DocumentDetailsAttributeParser {
    private static final int MINIMUM_ACCEPTABLE = 3;
    private static final int TYPE_INDEX = 0;
    private static final int COUNTRY_INDEX = 1;
    private static final int NUMBER_INDEX = 2;
    private static final int EXPIRATION_INDEX = 3;
    private static final int AUTHORITY_INDEX = 4;

    DocumentDetailsAttributeParser() {
    }

    DocumentDetails parseFrom(String attributeValue) throws UnsupportedEncodingException, ParseException {
        if (attributeValue == null || attributeValue.isEmpty()) {
            throw new IllegalArgumentException("Unable to parse attribute value to a DocumentDetails");
        }
        String[] attributes = attributeValue.split(" ");
        if (attributes.length < 3) {
            throw new IllegalArgumentException("Unable to parse attribute value to a DocumentDetails");
        }
        for (String s : attributes) {
            if (s != null && !s.isEmpty()) continue;
            throw new IllegalArgumentException("Invalid Document Details value, multiple consecutive spaces");
        }
        return DocumentDetails.builder().withType(attributes[0]).withIssuingCountry(attributes[1]).withNumber(attributes[2]).withDate(DocumentDetailsAttributeParser.getDateSafely(attributes, 3)).withAuthority(DocumentDetailsAttributeParser.getSafely(attributes, 4)).build();
    }

    private static Date getDateSafely(String[] attributes, int index) throws UnsupportedEncodingException, ParseException {
        String expirationDate = DocumentDetailsAttributeParser.getSafely(attributes, index);
        return expirationDate == null ? null : Date.parseFrom(expirationDate);
    }

    private static String getSafely(String[] attributes, int index) {
        String value = attributes.length > index ? attributes[index] : null;
        return "-".equals(value) ? null : value;
    }
}

