/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.ExtraData;
import com.yoti.api.client.ExtraDataException;
import com.yoti.api.client.spi.remote.DataEntryConverter;
import com.yoti.api.client.spi.remote.proto.DataEntryProto;
import com.yoti.api.client.spi.remote.proto.ExtraDataProto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraDataConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraDataConverter.class);
    private final DataEntryConverter dataEntryConverter;

    ExtraDataConverter(DataEntryConverter dataEntryConverter) {
        this.dataEntryConverter = dataEntryConverter;
    }

    public static ExtraDataConverter newInstance() {
        return new ExtraDataConverter(DataEntryConverter.newInstance());
    }

    public ExtraData read(byte[] extraDataBytes) throws ExtraDataException {
        if (extraDataBytes == null || extraDataBytes.length == 0) {
            return new ExtraData();
        }
        ExtraDataProto.ExtraData extraData = this.parseProto(extraDataBytes);
        List<Object> dataEntryList = this.parseDataEntries(extraData);
        return new ExtraData(dataEntryList);
    }

    private ExtraDataProto.ExtraData parseProto(byte[] extraDataBytes) throws ExtraDataException {
        try {
            return ExtraDataProto.ExtraData.parseFrom(extraDataBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ExtraDataException("Cannot parse extra data", e);
        }
    }

    private List<Object> parseDataEntries(ExtraDataProto.ExtraData extraData) {
        ArrayList<Object> parsedDataEntries = new ArrayList<Object>();
        for (DataEntryProto.DataEntry dataEntry : extraData.getListList()) {
            try {
                parsedDataEntries.add(this.dataEntryConverter.convertDataEntry(dataEntry));
            }
            catch (ExtraDataException e) {
                LOG.error("Failed to parse data entry: {}", (Object)e.getMessage());
            }
        }
        return parsedDataEntries;
    }
}

