/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.ExtraData;
import com.yoti.api.client.ExtraDataException;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.spi.remote.EncryptedDataReader;
import com.yoti.api.client.spi.remote.ExtraDataConverter;
import java.security.Key;

public class ExtraDataReader {
    private final EncryptedDataReader encryptedDataReader;
    private final ExtraDataConverter extraDataConverter;

    private ExtraDataReader(EncryptedDataReader encryptedDataReader, ExtraDataConverter extraDataConverter) {
        this.encryptedDataReader = encryptedDataReader;
        this.extraDataConverter = extraDataConverter;
    }

    static ExtraDataReader newInstance() {
        return new ExtraDataReader(EncryptedDataReader.newInstance(), ExtraDataConverter.newInstance());
    }

    ExtraData read(byte[] encryptedBytes, Key secretKey) throws ProfileException, ExtraDataException {
        ExtraData extraData;
        if (encryptedBytes != null && encryptedBytes.length > 0) {
            byte[] extraDataBytes = this.encryptedDataReader.decryptBytes(encryptedBytes, secretKey);
            extraData = this.extraDataConverter.read(extraDataBytes);
        } else {
            extraData = new ExtraData();
        }
        return extraData;
    }
}

