/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yoti.api.client.spi.remote.call.RawResourceFetcher;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.ResourceFetcher;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import java.io.IOException;

public final class JsonResourceFetcher
implements ResourceFetcher {
    private final ObjectMapper objectMapper;
    private final RawResourceFetcher rawResourceFetcher;

    public static JsonResourceFetcher newInstance() {
        return JsonResourceFetcher.newInstance(new RawResourceFetcher());
    }

    public static JsonResourceFetcher newInstance(RawResourceFetcher rawResourceFetcher) {
        return new JsonResourceFetcher(new ObjectMapper(), rawResourceFetcher);
    }

    private JsonResourceFetcher(ObjectMapper objectMapper, RawResourceFetcher rawResourceFetcher) {
        this.objectMapper = objectMapper;
        this.rawResourceFetcher = rawResourceFetcher;
    }

    @Override
    public <T> T doRequest(SignedRequest signedRequest, Class<T> resourceClass) throws ResourceException, IOException {
        SignedRequestResponse signedRequestResponse = this.rawResourceFetcher.doRequest(signedRequest);
        return (T)this.objectMapper.readValue(signedRequestResponse.getResponseBody(), resourceClass);
    }
}

