/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.yoti.api.client.spi.remote.call.HttpMethod;
import com.yoti.api.client.spi.remote.call.ImageResourceFetcher;
import com.yoti.api.client.spi.remote.call.JsonResourceFetcher;
import com.yoti.api.client.spi.remote.call.RawResourceFetcher;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.factory.HeadersFactory;
import com.yoti.api.client.spi.remote.call.factory.PathFactory;
import com.yoti.api.client.spi.remote.call.factory.SignedMessageFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;

public class SignedRequestBuilder {
    private KeyPair keyPair;
    private String baseUrl;
    private String endpoint;
    private byte[] payload;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private String httpMethod;
    private final PathFactory pathFactory;
    private final SignedMessageFactory signedMessageFactory;
    private final HeadersFactory headersFactory;
    private final JsonResourceFetcher jsonResourceFetcher;
    private final RawResourceFetcher rawResourceFetcher;
    private final ImageResourceFetcher imageResourceFetcher;

    SignedRequestBuilder(PathFactory pathFactory, SignedMessageFactory signedMessageFactory, HeadersFactory headersFactory, JsonResourceFetcher jsonResourceFetcher, RawResourceFetcher rawResourceFetcher, ImageResourceFetcher imageResourceFetcher) {
        this.pathFactory = pathFactory;
        this.signedMessageFactory = signedMessageFactory;
        this.headersFactory = headersFactory;
        this.jsonResourceFetcher = jsonResourceFetcher;
        this.rawResourceFetcher = rawResourceFetcher;
        this.imageResourceFetcher = imageResourceFetcher;
    }

    public SignedRequestBuilder withKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public SignedRequestBuilder withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl.replaceAll("([/]+)$", "");
        return this;
    }

    public SignedRequestBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SignedRequestBuilder withPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public SignedRequestBuilder withQueryParameter(String name, String value) {
        this.queryParameters.put(name, value);
        return this;
    }

    public SignedRequestBuilder withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public SignedRequestBuilder withHttpMethod(String httpMethod) throws IllegalArgumentException {
        Validation.withinList(httpMethod, HttpMethod.SUPPORTED_HTTP_METHODS);
        this.httpMethod = httpMethod;
        return this;
    }

    public SignedRequest build() throws GeneralSecurityException, UnsupportedEncodingException, URISyntaxException {
        this.validateRequest();
        this.endpoint = this.endpoint.contains("?") ? this.endpoint.concat("&") : this.endpoint.concat("?");
        String builtEndpoint = this.endpoint + this.createQueryParameterString(this.queryParameters);
        String digest = this.createDigest(builtEndpoint);
        this.headers.putAll(this.headersFactory.create(digest));
        return new SignedRequest(new URI(this.baseUrl + builtEndpoint), this.httpMethod, this.payload, this.headers, this.jsonResourceFetcher, this.rawResourceFetcher, this.imageResourceFetcher);
    }

    private void validateRequest() {
        Validation.notNull(this.keyPair, "keyPair");
        Validation.notNullOrEmpty(this.baseUrl, "baseUrl");
        Validation.notNullOrEmpty(this.endpoint, "endpoint");
        Validation.notNullOrEmpty(this.httpMethod, "httpMethod");
    }

    private String createQueryParameterString(Map<String, String> queryParameters) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
            stringBuilder.append("&");
        }
        stringBuilder.append(this.pathFactory.createSignatureParams());
        return stringBuilder.toString();
    }

    private String createDigest(String endpoint) throws GeneralSecurityException {
        if (this.payload != null) {
            return this.signedMessageFactory.create(this.keyPair.getPrivate(), this.httpMethod, endpoint, this.payload);
        }
        return this.signedMessageFactory.create(this.keyPair.getPrivate(), this.httpMethod, endpoint);
    }
}

