/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call.aml;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yoti.api.client.AmlException;
import com.yoti.api.client.aml.AmlProfile;
import com.yoti.api.client.aml.AmlResult;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestBuilderFactory;
import com.yoti.api.client.spi.remote.call.factory.UnsignedPathFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;

public class RemoteAmlService {
    private final UnsignedPathFactory unsignedPathFactory;
    private final ObjectMapper objectMapper;
    private final SignedRequestBuilderFactory signedRequestBuilderFactory;
    private final String apiUrl;

    public static RemoteAmlService newInstance() {
        return new RemoteAmlService(new UnsignedPathFactory(), new ObjectMapper(), new SignedRequestBuilderFactory());
    }

    RemoteAmlService(UnsignedPathFactory unsignedPathFactory, ObjectMapper objectMapper, SignedRequestBuilderFactory signedRequestBuilderFactory) {
        this.unsignedPathFactory = unsignedPathFactory;
        this.objectMapper = objectMapper;
        this.signedRequestBuilderFactory = signedRequestBuilderFactory;
        this.apiUrl = System.getProperty("yoti.api.url", "https://api.yoti.com/api/v1");
    }

    public AmlResult performCheck(KeyPair keyPair, String appId, AmlProfile amlProfile) throws AmlException {
        Validation.notNull(keyPair, "Key pair");
        Validation.notNull(appId, "Application id");
        Validation.notNull(amlProfile, "amlProfile");
        try {
            String resourcePath = this.unsignedPathFactory.createAmlPath(appId);
            byte[] body = this.objectMapper.writeValueAsString((Object)amlProfile).getBytes("UTF-8");
            SignedRequest signedRequest = this.createSignedRequest(keyPair, resourcePath, body);
            return signedRequest.execute(AmlResult.class);
        }
        catch (IOException ioException) {
            throw new AmlException("Error communicating with AML endpoint", ioException);
        }
        catch (ResourceException resourceException) {
            throw this.createExceptionFromStatusCode(resourceException);
        }
    }

    private AmlException createExceptionFromStatusCode(ResourceException e) {
        switch (e.getResponseCode()) {
            case 400: {
                return new AmlException("Failed validation:\n" + e.getResponseBody(), e);
            }
            case 401: {
                return new AmlException("Failed authorization with the given key:\n" + e.getResponseBody(), e);
            }
            case 500: {
                return new AmlException("An unexpected error occured on the server:\n" + e.getResponseBody(), e);
            }
        }
        return new AmlException("Unexpected error:\n" + e.getResponseBody(), e);
    }

    SignedRequest createSignedRequest(KeyPair keyPair, String resourcePath, byte[] body) throws AmlException {
        try {
            return this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(resourcePath).withPayload(body).withHttpMethod("POST").build();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AmlException("Cannot sign request", generalSecurityException);
        }
        catch (UnsupportedEncodingException | URISyntaxException uriSyntaxException) {
            throw new AmlException("Error creating request", uriSyntaxException);
        }
    }
}

